/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.type.AmbiguousTypeNameException;

abstract class ParticipantFeature
extends FeatureSet {
    protected FlowNode node;
    protected OperationNameFeature operationName;
    protected ParticipantNameFeature participantName;

    protected ParticipantFeature(String name, FlowNode node) {
        super(name, null, null);
        this.node = node;
        this.participantName = new ParticipantNameFeature();
        this.addFeature(this.participantName);
        this.operationName = new OperationNameFeature();
        this.addFeature(this.operationName);
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof ParticipantFeature) {
            ParticipantFeature source = (ParticipantFeature)feature;
            this.setParticipantName(source.getParticipantName());
            this.setOperationName(source.getOperationName());
        }
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }

    protected String getParticipantName() {
        return this.participantName.getValue();
    }

    protected String getOperationName() {
        return this.operationName.getValue();
    }

    protected void setOperationName(String operationName) {
        this.operationName.setValue(operationName);
    }

    protected void setParticipant(CatalogObject participant) {
        this.participantName.setValue(participant != null ? participant.getText() : "");
    }

    protected void setParticipantName(String participantName) {
        this.participantName.setValue(participantName);
    }

    protected CatalogMember getOperation() {
        CatalogMember result = null;
        CatalogObject participant = this.getParticipant();
        String operationName = this.getOperationName();
        if (participant != null && !Str.isEmpty(operationName)) {
            result = participant.findMember(operationName);
        }
        return result;
    }

    protected CatalogObject getParticipant() {
        CatalogObject result = null;
        Project project = this.node.getProject();
        if (project != null && !Str.isEmpty(this.getParticipantName())) {
            try {
                result = project.findCatalogObject(this.getParticipantName());
            }
            catch (AmbiguousTypeNameException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void setOperation(CatalogMember operation) {
        if (operation != null) {
            this.setParticipant(operation.getParentObject());
            this.operationName.setValue(operation.getName());
        } else {
            this.setParticipant(null);
            this.operationName.setValue("");
        }
    }

    private static class OperationNameFeature
    extends StringFeature {
        public OperationNameFeature() {
            super("operationName", ProjectModelMsg.METHOD_NAME, null, null);
        }

        public static OperationNameFeature create() {
            return new OperationNameFeature();
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public class ParticipantNameFeature
    extends StringFeature {
        public ParticipantNameFeature() {
            super("serviceName", ProjectModelMsg.COMPONENT_NAME, null, null);
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }
}

