/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Any;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.NotificationObject;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import org.jetbrains.annotations.NotNull;

public class NotificationFeature
extends FeatureSet {
    private NotificationDefinition notificationDefinition;
    private NotificationObject notificationObject;
    private NotificationTask notificationTask;
    private NotificationTypeFeature typeFeature;

    protected NotificationFeature(@NotNull NotificationTask notificationTask) {
        super("notification", null, null);
        this.notificationTask = notificationTask;
        this.typeFeature = new NotificationTypeFeature();
        this.addFeature(this.typeFeature);
        this.addFeature(InputArgumentsFeature.create(notificationTask));
        this.addFeature(InputDataAssociationFeature.create(notificationTask));
        this.addFeature(LoggableFeature.create(notificationTask));
    }

    public static NotificationFeature create(@NotNull NotificationTask notificationTask) {
        return new NotificationFeature(notificationTask);
    }

    public DataDeclarationContainer getNotificationArguments() {
        NotificationType type = this.getNotificationType();
        return this.getNotificationObject().getArguments(type);
    }

    public NotificationType getNotificationType() {
        return (NotificationType)((Object)this.typeFeature.getValue());
    }

    public NotificationDefinition getNotificationDefinition() {
        if (this.notificationDefinition == null) {
            this.updateNotificationDefinition();
        }
        return this.notificationDefinition;
    }

    public boolean setNotificationType(@NotNull NotificationType type) {
        if (Any.equals((Object)this.getNotificationType(), (Object)type)) {
            return false;
        }
        this.typeFeature.setValue(type);
        this.updateNotificationDefinition();
        return true;
    }

    @Override
    public void copyFrom(Feature feature) {
        NotificationFeature sourceFeature;
        boolean mustUpdateDefinition = false;
        if (feature instanceof NotificationFeature && (sourceFeature = (NotificationFeature)feature).getNotificationType() != this.getNotificationType()) {
            mustUpdateDefinition = true;
        }
        super.copyFrom(feature);
        if (mustUpdateDefinition) {
            this.updateNotificationDefinition();
        }
    }

    private NotificationObject getNotificationObject() {
        if (this.notificationObject == null) {
            this.notificationObject = this.notificationTask.createNotificationObject();
        }
        return this.notificationObject;
    }

    private void updateNotificationDefinition() {
        NotificationType type = this.getNotificationType();
        this.notificationDefinition = this.notificationTask.createNotificationDefinition(type);
    }

    public static class NotificationTypeFeature
    extends EnumFeature<NotificationType> {
        public static String FEATURE_NAME = "notificationType";

        public NotificationTypeFeature() {
            super(NotificationType.class, FEATURE_NAME, null, null, NotificationType.DEFAULT);
        }
    }
}

