/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.Map;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.resources.Msg;

public class FloatFeature
extends PersistentFeature<Float> {
    private Float defaultValue;
    private Float maxValue = Float.valueOf(Float.MAX_VALUE);
    private Float minValue = Float.valueOf(Float.MIN_VALUE);
    private Float prevValue;
    private Float value;
    public static final IntFeature DEFAULT = new IntFeature("default", null, null, 0);

    protected FloatFeature(String featureName, Msg label, Msg description, Float value) {
        super(featureName, label, description);
        this.defaultValue = value;
        this.setValue(value);
    }

    public static FloatFeature create(String featureName, Float value) {
        return FloatFeature.create(featureName, null, null, value);
    }

    public static FloatFeature create(String featureName, Msg label) {
        return FloatFeature.create(featureName, label, null, Float.valueOf(0.0f));
    }

    public static FloatFeature create(String featureName, Msg label, Msg description, Float value) {
        return new FloatFeature(featureName, label, description, value);
    }

    @Override
    public Float getValue() {
        return this.value;
    }

    @Override
    public Float getPrevValue() {
        return this.prevValue;
    }

    public Float getDefaultValue() {
        return this.defaultValue;
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Float minValue) {
        this.minValue = minValue;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
        Object s = propertiesFor.get(this.getName());
        if (s != null) {
            this.setObjectValue(s);
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public void setValue(Float value) {
        boolean fire = false;
        if (!Any.equals(this.value, value)) {
            this.prevValue = this.value;
            fire = true;
        }
        this.value = value;
        if (fire) {
            this.fireChanged();
        }
    }

    @Override
    public void setValue(String value) {
        this.setValue(Float.valueOf(value));
    }

    public Feature getDefault() {
        return DEFAULT;
    }
}

