/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.Map;
import oracle.bpm.lang.Id;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public class FileRevisionFeature
extends FeatureSet {
    protected FileRevisionFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(VersionFeature.create());
        this.addFeature(RevisionFeature.create());
    }

    public static FileRevisionFeature create() {
        return new FileRevisionFeature("revision", null, null);
    }

    public void setRevision(int revisionNumber) {
        this.getFeature(RevisionFeature.class).setValue(revisionNumber);
    }

    public void setVersion(String version) {
        this.getFeature(VersionFeature.class).setValue(version);
    }

    public int getRevision() {
        return this.getFeature(RevisionFeature.class).getValue();
    }

    public String getVersion() {
        return this.getFeature(VersionFeature.class).getValue();
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }

    private static class VersionFeature
    extends StringFeature {
        private static final String VERSION = "version";

        protected VersionFeature(@NonNls String featureName, String value) {
            super(featureName, null, null, value);
        }

        public static VersionFeature create() {
            return new VersionFeature(VERSION, Id.getAbsoluteVersion());
        }

        @Override
        public void fill(Map<String, Object> propertiesFor) {
            Object value = propertiesFor.get(this.getName());
            if (value != null) {
                this.setObjectValue(value);
            }
        }
    }

    private static class RevisionFeature
    extends IntFeature {
        private static final String REVISION = "revision";

        protected RevisionFeature(@NonNls String featureName, int value) {
            super(featureName, null, null, value);
        }

        public static RevisionFeature create() {
            return new RevisionFeature(REVISION, Integer.valueOf("20120217"));
        }

        @Override
        public void fill(Map<String, Object> propertiesFor) {
            Object value = propertiesFor.get(this.getName());
            if (value != null) {
                this.setObjectValue(value);
            }
        }
    }
}

