/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.iterator.ReadOnlyIterator;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.NonPersistentFeature;
import oracle.bpm.project.model.features.PersistentFeature;
import org.jetbrains.annotations.Nullable;

public class Features
implements Iterable<Feature> {
    final List<Feature> values = new ArrayList<Feature>();
    private Map<Class, Feature> featuresMap = null;
    private Iterable<PersistentFeature> persistentFeaturesIterable;
    private Iterable<PersistentFeature> publicFeaturesIterable;

    private Features(Map<Class, Feature> featuresMap) {
        this.extendFeatures(featuresMap);
    }

    public static Features create(Map<Class, Feature> featuresMap) {
        return new Features(featuresMap);
    }

    @Nullable
    public <T extends Feature> T getFeature(Class<T> clazz) {
        Feature feature = this.featuresMap.get(clazz);
        if (feature != null) {
            return (T)((Feature)clazz.cast(feature));
        }
        return null;
    }

    public <T> T getValue(Class<? extends Feature<T>> clazz) {
        Feature<T> f = this.getFeature(clazz);
        return f == null ? null : (T)f.getValue();
    }

    @Override
    public Iterator<Feature> iterator() {
        return ReadOnlyIterator.create(this.values.iterator());
    }

    public Iterable<PersistentFeature> persistentFeatures() {
        if (this.persistentFeaturesIterable == null) {
            this.persistentFeaturesIterable = CollectionUtils.selectInstanceOf(this, PersistentFeature.class);
        }
        return this.persistentFeaturesIterable;
    }

    public Iterable<PersistentFeature> publicFeatures() {
        if (this.publicFeaturesIterable == null) {
            this.publicFeaturesIterable = CollectionUtils.select(this.persistentFeatures(), new Predicate<PersistentFeature>(){

                @Override
                public boolean check(PersistentFeature value) {
                    return value.isPublic();
                }
            });
        }
        return this.publicFeaturesIterable;
    }

    public void copyFrom(Features source) {
        if (source != null) {
            for (Feature feature : source) {
                Object targetFeature = this.getFeature(feature.getClass());
                if (targetFeature == null) continue;
                if (targetFeature instanceof PersistentFeature) {
                    PersistentFeature pFeature = (PersistentFeature)targetFeature;
                    pFeature.copyFrom(feature);
                    continue;
                }
                if (!(targetFeature instanceof NonPersistentFeature)) continue;
                NonPersistentFeature pFeature2 = (NonPersistentFeature)targetFeature;
                pFeature2.copyFrom(feature);
            }
        }
    }

    public <T extends Feature> T find(Class<T> clazz) {
        Feature result = null;
        for (Feature value : this.values) {
            FeatureSet set;
            if (clazz.isInstance(value)) {
                result = (Feature)clazz.cast(value);
                break;
            }
            if (!(value instanceof FeatureSet) || (result = (set = (FeatureSet)value).find(clazz)) == null) continue;
            break;
        }
        return (T)result;
    }

    public <T extends Feature> T findExact(Class<T> clazz) {
        Feature result = null;
        for (Feature feature : this.values) {
            FeatureSet set;
            if (feature.getClass() == clazz) {
                result = (Feature)clazz.cast(feature);
                break;
            }
            if (!(feature instanceof FeatureSet) || (result = (set = (FeatureSet)feature).findExact(clazz)) == null) continue;
            break;
        }
        return (T)result;
    }

    public final void extendFeatures(Map<Class, Feature> map) {
        if (this.featuresMap == null) {
            this.featuresMap = new HashMap<Class, Feature>(map);
        } else {
            this.featuresMap.putAll(map);
        }
        for (Feature feature : map.values()) {
            if (this.values.contains(feature)) continue;
            this.values.add(feature);
        }
        Collections.sort(this.values, new Comparator<Feature>(){

            @Override
            public int compare(Feature o1, Feature o2) {
                if (o1.getSortHint() != o2.getSortHint()) {
                    return o1.getSortHint();
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public final void extendFeatures(Features features) {
        for (Feature feature : features) {
            this.extendFeature(feature);
        }
    }

    public final void extendFeature(Feature feature) {
        if (this.featuresMap == null) {
            this.featuresMap = new HashMap<Class, Feature>();
        }
        this.featuresMap.put(feature.getClass(), feature);
        if (!this.values.contains(feature)) {
            this.values.add(feature);
        }
        Collections.sort(this.values, new Comparator<Feature>(){

            @Override
            public int compare(Feature o1, Feature o2) {
                if (o1.getSortHint() != o2.getSortHint()) {
                    return o1.getSortHint();
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public void print() {
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter pw = new IndentedPrintWriter(stringWriter);
        pw.println("*** Start printing features ***");
        for (Feature value : this.values) {
            Features.printFeature(pw, value);
        }
        System.out.println(stringWriter.getBuffer());
    }

    <T extends Feature> boolean hasFeature(Class<T> clazz) {
        return this.featuresMap.containsKey(clazz);
    }

    private static void printFeature(IndentedPrintWriter pw, Feature value) {
        if (value instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)value;
            pw.indent();
            pw.println("FeatureSet " + value.getName());
            for (Feature feature : featureSet.getFeatures()) {
                Features.printFeature(pw, feature);
            }
            pw.dedent();
        } else {
            pw.println("Feature: " + value.getName() + " value: " + value.getValue());
        }
    }
}

