/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.resources.Msg;

public class ErrorEventDefinitionFeature
extends FeatureSet {
    private CatchAllFeature catchAllFeature;
    private CatchAllSystemExceptionsFeature catchAllSystemExceptionsFeature;
    private ErrorObject error;
    private ErrorCodeFeature errorCodeFeature = new ErrorCodeFeature();

    protected ErrorEventDefinitionFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(this.errorCodeFeature);
        this.catchAllFeature = new CatchAllFeature();
        this.addFeature(this.catchAllFeature);
        this.catchAllSystemExceptionsFeature = new CatchAllSystemExceptionsFeature();
        this.addFeature(this.catchAllSystemExceptionsFeature);
    }

    public static ErrorEventDefinitionFeature create() {
        return new ErrorEventDefinitionFeature("errorEventDefinition", null, null);
    }

    public String getErrorCode() {
        return this.errorCodeFeature.getValue();
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof ErrorEventDefinitionFeature) {
            ErrorEventDefinitionFeature source = (ErrorEventDefinitionFeature)feature;
            this.error = source.getError();
        }
    }

    public boolean isCatchAll() {
        return this.catchAllFeature.getValue();
    }

    public boolean isCatchAllSystemExceptions() {
        return this.catchAllSystemExceptionsFeature.getValue();
    }

    public void setIsCatchAll(boolean isCatchAll) {
        this.catchAllFeature.setValue(isCatchAll);
        if (isCatchAll) {
            this.setError(null);
        }
    }

    public void setIsCatchAllSystemExceptions(boolean isCatchAll) {
        this.catchAllSystemExceptionsFeature.setValue(isCatchAll);
        if (isCatchAll) {
            this.setError(null);
        }
    }

    public void setError(ErrorObject error) {
        this.error = error;
        this.errorCodeFeature.setValue(error != null ? error.getText() : "");
    }

    public ErrorObject getError() {
        return this.error;
    }

    private static class ErrorCodeFeature
    extends StringFeature {
        public ErrorCodeFeature() {
            super("errorCode", null, null, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    private static class CatchAllSystemExceptionsFeature
    extends BooleanFeature {
        public CatchAllSystemExceptionsFeature() {
            super("catchAllSystemExceptions", null, null, false);
        }
    }

    private static class CatchAllFeature
    extends BooleanFeature {
        public CatchAllFeature() {
            super("catchAllErrors", null, null, false);
        }
    }
}

