/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Activable;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.transitions.TransitionMethodFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;

public class DueIntervalFeature
extends TransitionMethodFeature
implements Activable {
    private boolean active = true;

    private DueIntervalFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
    }

    public static DueIntervalFeature create() {
        return new DueIntervalFeature("dueInterval", ProjectModelMsg.INTERVAL_EXPRESSION, null);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        if (this.isActive()) {
            super.visit(visitor);
        }
    }

    @Override
    public void setActive(boolean value) {
        this.active = value;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public TypeDescription getReturnType() {
        return TypeFactory.getInterval();
    }

    public Interval getInterval() {
        String conditionValue = this.getValue().getExpressionValue().trim();
        if (conditionValue.startsWith("'")) {
            conditionValue = conditionValue.substring(1);
        }
        if (conditionValue.endsWith("'")) {
            conditionValue = conditionValue.substring(0, conditionValue.lastIndexOf(39));
        }
        try {
            return Interval.valueOf(conditionValue);
        }
        catch (IntervalFormatException intervalFormatException) {
            return Interval.ZERO;
        }
    }
}

