/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.OutputDataAssociationFeature;
import oracle.bpm.project.model.features.ParticipantFeature;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsFeature;
import org.jetbrains.annotations.NotNull;

public class BusinessRuleTaskFeature
extends ParticipantFeature {
    private BusinessRuleTaskFeature(@NotNull BusinessRuleTask businessRuleTask) {
        super("businessRuleTask", businessRuleTask);
        this.addFeature(LoopCharacteristicsFeature.create(businessRuleTask));
        this.addFeature(InputDataAssociationFeature.create(businessRuleTask));
        this.addFeature(OutputDataAssociationFeature.create(businessRuleTask));
        this.addFeature(InputArgumentsFeature.create(businessRuleTask));
        this.addFeature(OutputArgumentsFeature.create(businessRuleTask));
        this.addFeature(LoggableFeature.create(businessRuleTask));
    }

    public static BusinessRuleTaskFeature create(@NotNull BusinessRuleTask businessRuleTask) {
        return new BusinessRuleTaskFeature(businessRuleTask);
    }

    public BusinessRule getBusinessRule() {
        CatalogObject catalogObject = this.getParticipant();
        return catalogObject == null ? null : catalogObject.asChild(BusinessRule.class);
    }

    public void setBusinessRule(BusinessRule rule) {
        super.setParticipant(rule);
    }

    public CatalogMember getFunction() {
        return this.getOperation();
    }

    public void setFunction(CatalogMember function) {
        super.setOperation(function);
    }
}

