/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.messageheaders.MessageHeader;
import oracle.bpm.project.model.processes.messageheaders.MessageHeaderSet;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMessageHeaderSetFeature
extends PersistentFeature<MessageHeaderSet> {
    private MessageHeadersEnabled messageHeadersEnabled;
    private MessageHeaderSet messageHeaderSet;

    protected AbstractMessageHeaderSetFeature(@NotNull String name, @NotNull MessageHeadersEnabled messages) {
        super(name, null, null);
        this.messageHeadersEnabled = messages;
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }

    @Override
    public MessageHeaderSet getValue() {
        if (this.messageHeaderSet == null) {
            this.messageHeaderSet = this.messageHeadersEnabled.createMessageHeaderSet();
        }
        return this.messageHeaderSet;
    }

    @Override
    public void setValue(MessageHeaderSet value) {
        this.messageHeaderSet = value;
    }

    @Override
    public MessageHeaderSet getPrevValue() {
        return null;
    }

    @Override
    public void copyFrom(Feature<? extends MessageHeaderSet> feature) {
        this.getValue().clearMessageHeaders();
        for (MessageHeader messageHeader : feature.getValue().getMessageHeaders()) {
            MessageHeader newMessage = this.getValue().createMessageHeader(messageHeader.getName());
            try {
                this.getValue().addMessageHeader(newMessage);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }
}

