/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.exception;

import oracle.bpm.lang.DefaultException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class InvalidExpressionException
extends DefaultException {
    static final long serialVersionUID = 2658700351653880316L;

    private InvalidExpressionException(Msg message) {
        super(message);
    }

    public static InvalidExpressionException createExpressionIsInvalid(@NotNull Msg message) {
        return new ExpressionIsInvalidException(message);
    }

    public static InvalidExpressionException createXPathExpressionIsInvalid(@NotNull String expression, @NotNull Exception exception) {
        return new ExpressionIsInvalidException(ProjectModelMsg.XPATH_EXPRESSION_IS_INVALID(expression, exception.getLocalizedMessage()));
    }

    public static InvalidExpressionException undefinedPrefixes(@NotNull String expression, @NotNull Iterable<String> prefixes) {
        return new ExpressionIsInvalidException(ProjectModelMsg.XPATH_UNDEFINED_PREFIXES(expression, prefixes.toString()));
    }

    private static class ExpressionIsInvalidException
    extends InvalidExpressionException {
        static final long serialVersionUID = 2658700351653880316L;

        private ExpressionIsInvalidException(Msg message) {
            super(message);
        }
    }
}

