/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.events;

import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;

public class BatchProjectListenerAdapter<E extends ProjectObject>
implements ProjectListener<E> {
    private Class<E> types;

    public BatchProjectListenerAdapter(Class<E> type) {
        assert (type.isInterface());
        this.types = type;
    }

    @Override
    public Class<E> getSupportedTypes() {
        return this.types;
    }

    @Override
    public void processPreEvents(ProjectEventSet events) throws ProjectException {
    }

    @Override
    public void processPostEvents(ProjectEventSet events) {
    }

    @Override
    public final void postObjectAdded(E object, ProjectObject parent) {
        this.processPostEvents(ProjectEventSet.createFrom(ProjectEvent.POST_ADD(object, parent)));
    }

    @Override
    public final void postObjectRemoved(E object, ProjectObject parent) {
        this.processPostEvents(ProjectEventSet.createFrom(ProjectEvent.POST_REMOVE(object, parent)));
    }

    @Override
    public final void objectChanged(E projectObject, ProjectEvent event) {
        this.processPostEvents(ProjectEventSet.createFrom(event));
    }

    @Override
    public final void preObjectAdded(E object, ProjectObject parent) throws ProjectException {
        this.processPreEvents(ProjectEventSet.createFrom(ProjectEvent.PRE_ADD(object, parent)));
    }

    @Override
    public final void preObjectRemoved(E object, ProjectObject parent) throws ProjectException {
        this.processPreEvents(ProjectEventSet.createFrom(ProjectEvent.PRE_REMOVE(object, parent)));
    }

    @Override
    public final void objectReplaced(E oldObject, E newObject) {
        this.processPostEvents(ProjectEventSet.createFrom(ProjectEvent.REPLACE(oldObject, newObject)));
    }
}

