/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.casemgmt;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalType;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseActivityUtils {
    private static final String EXEC_DATA = "execData";
    private static final String OUTCOME = "outcome";
    private static final String INVOKE = "invoke";

    private CaseActivityUtils() {
    }

    public static Collection<CatchEvent> getOperations(Process process) {
        ArrayList<CatchEvent> result = new ArrayList<CatchEvent>();
        Sequence<FlowNode> nodes = ModelUtils.getStartNodes(process);
        for (FlowNode node : nodes) {
            ConversationType type;
            Conversation conversation;
            CatchEvent start;
            Event event;
            if (!node.getBpmnType().isEvent() || !(event = node.asAnyNode(Event.class)).isCatchEvent() || (start = event.asCatchEvent()).getEventTriggerType() != EventTriggerType.MESSAGE || (conversation = start.getConversation()) == null || (type = conversation.getConversationType()) != ConversationType.DEFINE_INTERFACE) continue;
            result.add(start);
        }
        return result;
    }

    public static CatchEvent getOperationByName(Project project, ComponentInfo componentInfo) {
        CatchEvent result = null;
        String referenceId = componentInfo.getReferenceId();
        Process process = project.findProcess(referenceId);
        if (process != null) {
            String operation = componentInfo.getOperation();
            result = CaseActivityUtils.getOperationByName(process, operation);
        }
        return result;
    }

    public static CatchEvent getOperationByName(Process process, String name) {
        CatchEvent result = null;
        Collection<CatchEvent> operations = CaseActivityUtils.getOperations(process);
        for (CatchEvent catchEvent : operations) {
            String operationName = CaseActivityUtils.getOperationName(catchEvent);
            if (!name.equals(operationName)) continue;
            result = catchEvent;
            break;
        }
        return result;
    }

    public static String getOperationName(CatchEvent catchEvent) {
        String result = "<no-define-interface>";
        if (CaseActivityUtils.isDefineInterface(catchEvent)) {
            DefineInterfaceConversationalDefinition definition = catchEvent.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
            result = definition.getDefinedOperationName();
        }
        return result;
    }

    public static boolean isSynchronous(CatchEvent catchEvent) {
        Conversation conversation = catchEvent.getConversation();
        if (conversation != null) {
            for (Conversational conversational : conversation.getConversationals()) {
                DefineInterfaceConversationalDefinition definition;
                if (conversation.getConversationType() != ConversationType.DEFINE_INTERFACE || (definition = conversational.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class)).getReplyTo() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static InputParameters createInputParameters(CatchEvent catchEvent, @Nullable Case casemgmt) {
        InputParameters result = CaseActivityFactory.createInputParameters();
        Sequence<DataDeclaration> declarations = CaseActivityUtils.getInputDeclarations(catchEvent);
        for (DataDeclaration argument : declarations) {
            String schemaLocation;
            CatalogType type = argument.getType();
            if (!type.getDelegate().isSchemaObject()) continue;
            SchemaObject schemaObject = type.getDelegate().asSchemaObject();
            InputParameter.CaseData caseDataInput = CaseActivityFactory.createCaseDataInputParameter();
            String paramName = argument.getName();
            String elementName = CaseActivityUtils.getElementName(schemaObject, paramName);
            QName qName = schemaObject.getQName();
            caseDataInput.setParamName(paramName);
            caseDataInput.setElementName(elementName);
            InputParameter.Payload payload = caseDataInput.toPayload();
            if (qName != null) {
                payload.setElementType(qName.toString());
            }
            if ((schemaLocation = CaseActivityUtils.getSchemaLocation(schemaObject)) != null) {
                payload.setElementSchemaLocation(schemaLocation);
            }
            payload.setElementDataType(CaseActivityUtils.getElementType(schemaObject));
            caseDataInput.toCaseData();
            if (casemgmt != null) {
                Data data = CaseActivityUtils.findOrCreateData(casemgmt, type, argument.getName());
                caseDataInput.setDataName(data.getName());
            }
            result.add((Object)caseDataInput);
        }
        return result;
    }

    public static InputParameters createInputParameters(HumanTask task, Case casemgmt) {
        InputParameters result = CaseActivityFactory.createInputParameters();
        Sequence<DataDeclaration> inputDeclarations = CaseActivityUtils.getInputDeclarations(task);
        for (DataDeclaration inDeclaration : inputDeclarations) {
            String schemaLocation;
            CatalogType type = inDeclaration.getType();
            if (!type.getDelegate().isSchemaObject()) continue;
            SchemaObject schemaObject = type.getDelegate().asSchemaObject();
            InputParameter.Payload payload = CaseActivityFactory.createPayloadInputParameter();
            String paramName = inDeclaration.getName();
            String elementName = CaseActivityUtils.getElementName(schemaObject, paramName);
            QName qName = schemaObject.getQName();
            payload.setParamName(paramName);
            payload.setElementName(elementName);
            if (qName != null) {
                payload.setElementType(qName.toString());
            }
            if ((schemaLocation = CaseActivityUtils.getSchemaLocation(schemaObject)) != null) {
                payload.setElementSchemaLocation(schemaLocation);
            }
            payload.setElementDataType(CaseActivityUtils.getElementType(schemaObject));
            if (casemgmt != null) {
                Data data = CaseActivityUtils.findOrCreateData(casemgmt, type, inDeclaration.getName());
                payload.setDataName(data.getName());
            }
            result.add((Object)payload);
        }
        return result;
    }

    public static String getSchemaLocation(@NotNull SchemaObject schemaObject) {
        URI resourceUri = schemaObject.getResourceUri();
        String result = null;
        try {
            String string = result = resourceUri != null ? resourceUri.getPath().toString() : null;
            if (result != null && result.startsWith("/") && result.length() > 1) {
                result = result.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static DataType getElementType(@NotNull SchemaObject schemaObject) {
        DataType result = schemaObject.isBasicType() ? DataType.SIMPLE_TYPE : (schemaObject.isElement() ? DataType.ELEMENT : DataType.COMPLEX_TYPE);
        return result;
    }

    public static Sequence<DataDeclaration> getInputDeclarations(Project project, CaseActivity caseActivity) {
        Sequence<DataDeclaration> result = CollectionUtils.asSequence(new ArrayList());
        Activity activity = caseActivity.getActivity();
        Activity.Type type = activity.getType();
        if (type.isBpmn()) {
            result = CaseActivityUtils.getBpmnInputDeclarations(project, activity.toBpmn().getComponentInfo());
        } else if (type.isHumantask()) {
            result = CaseActivityUtils.getHumanTaskInputDeclarations(project, activity.toHumanTask().getComponentInfo());
        }
        return result;
    }

    public static Sequence<DataDeclaration> getBpmnInputDeclarations(Project project, ComponentInfo componentInfo) {
        CatchEvent catchEvent = CaseActivityUtils.getOperationByName(project, componentInfo);
        return catchEvent != null ? CaseActivityUtils.getInputDeclarations(catchEvent) : CollectionUtils.asSequence(new ArrayList());
    }

    public static Sequence<DataDeclaration> getHumanTaskInputDeclarations(Project project, ComponentInfo componentInfo) {
        Sequence<DataDeclaration> result = CollectionUtils.asSequence(new ArrayList());
        String referenceId = componentInfo.getReferenceId();
        HumanTask task = CaseManagementUtils.getHumanTask(project, referenceId);
        if (task != null) {
            result = CaseActivityUtils.getInputDeclarations(task);
        }
        return result;
    }

    public static Sequence<DataDeclaration> getInputDeclarations(HumanTask task) {
        CatalogMember invoke = task.findMember(INVOKE);
        DataDeclarationContainer inputArgumentsContainer = invoke.getInputArgumentsContainer();
        Predicate<DataDeclaration> filter = new Predicate<DataDeclaration>(){

            @Override
            public boolean check(@Nullable DataDeclaration value) {
                return !CaseActivityUtils.isExecData(value);
            }
        };
        return inputArgumentsContainer.getDeclarations().select(filter);
    }

    public static CatalogType getCatalogTypeByName(Sequence<DataDeclaration> declarations, final @NotNull String name) {
        DataDeclaration declaration = CollectionUtils.findFirst(declarations, new Predicate<DataDeclaration>(){

            @Override
            public boolean check(@Nullable DataDeclaration value) {
                return value != null && name.equals(value.getName());
            }
        });
        return declaration != null ? declaration.getType() : null;
    }

    public static Sequence<DataDeclaration> getOutputDeclarations(HumanTask task) {
        CatalogMember invoke = task.findMember(INVOKE);
        DataDeclarationContainer outputArgumentsContainer = invoke.getOutputArgumentsContainer();
        Predicate<DataDeclaration> filter = new Predicate<DataDeclaration>(){

            @Override
            public boolean check(@Nullable DataDeclaration value) {
                return !CaseActivityUtils.isExecData(value) && !CaseActivityUtils.isOutcome(value);
            }
        };
        return outputArgumentsContainer.getDeclarations().select(filter);
    }

    public static OutputParameters createOutputParameters(HumanTask task, @Nullable Case casemgmt) {
        OutputParameters result = CaseActivityFactory.createOutputParameters();
        Sequence<DataDeclaration> outputDeclarations = CaseActivityUtils.getOutputDeclarations(task);
        if (!outputDeclarations.isEmpty()) {
            Output output = CaseActivityFactory.createOutput();
            for (DataDeclaration outDeclaration : outputDeclarations) {
                CatalogType type = outDeclaration.getType();
                if (!type.getDelegate().isSchemaObject()) continue;
                SchemaObject schemaObject = type.getDelegate().asSchemaObject();
                OutputParameter.NormalizedMessage parameter = CaseActivityFactory.createNormalizedMessageOutputParameter();
                String paramName = outDeclaration.getName();
                String elementName = CaseActivityUtils.getElementName(schemaObject, paramName);
                parameter.setParamName(paramName);
                parameter.setElementName(elementName);
                parameter.setStoreData(true);
                if (casemgmt != null && parameter.isStoreData()) {
                    Data data = CaseActivityUtils.findOrCreateData(casemgmt, type, outDeclaration.getName());
                    parameter.setDataName(data.getName());
                }
                output.add((Object)parameter);
            }
            if (!output.isEmpty()) {
                result.add((Object)output);
            }
        }
        return result;
    }

    public static OutputParameters createOutputParameters(Conversational entryPoint, @Nullable Case casemgmt) {
        OutputParameters result = CaseActivityFactory.createOutputParameters();
        OutputDeclarations outputDeclarations = CaseActivityUtils.getOutputDeclarations(entryPoint);
        List<OutputDeclarations.Entry> entries = outputDeclarations.getEntries();
        for (OutputDeclarations.Entry entry : entries) {
            Output output = CaseActivityUtils.createOutput(entry.getOperationName(), entry.getEndPoint(), entry.getDeclarations(), casemgmt);
            result.add((Object)output);
        }
        return result;
    }

    public static OutputDeclarations getOutputDeclarations(Conversational entryPoint) {
        OutputDeclarations result = OutputDeclarations.create();
        Conversation conversation = entryPoint.getConversation();
        if (conversation != null) {
            Sequence<Conversational> conversationals = conversation.getConversationals();
            for (Conversational conversational : conversationals) {
                ConversationalType conversationalType = conversational.getConversationalType();
                if (!conversationalType.isSender()) continue;
                if (CaseActivityUtils.isDefineInterface(entryPoint)) {
                    String operationName;
                    DefineInterfaceConversationalDefinition definition = conversational.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                    DataDeclarationContainer argumentsContainer = definition.getArgumentsContainer();
                    Sequence<DataDeclaration> declarations = argumentsContainer.getDeclarations();
                    String endPoint = conversational.getId();
                    Conversational replyTo = definition.getReplyTo();
                    if (replyTo != null) {
                        DefineInterfaceConversationalDefinition replyToDefinition = replyTo.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                        operationName = replyToDefinition.getDefinedOperationName();
                    } else {
                        operationName = definition.getDefinedOperationName();
                    }
                    result.add(operationName, endPoint, declarations);
                    continue;
                }
                if (!CaseActivityUtils.isUseInterface(entryPoint)) continue;
            }
        }
        return result;
    }

    public static Sequence<DataDeclaration> getInputDeclarations(CatchEvent catchEvent) {
        Sequence<DataDeclaration> result = CollectionUtils.asSequence(new ArrayList());
        if (CaseActivityUtils.isDefineInterface(catchEvent)) {
            DefineInterfaceConversationalDefinition definition = catchEvent.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
            DataDeclarationContainer argumentsContainer = definition.getArgumentsContainer();
            result = argumentsContainer.getDeclarations();
        }
        return result;
    }

    private static Data findOrCreateData(Case casemgmt, CatalogType type, String name) {
        Data result;
        List caseDataList = casemgmt.getCaseData();
        boolean existCaseData = !caseDataList.isEmpty();
        Data data = result = existCaseData ? CaseActivityUtils.findValidCaseDataByNameAndType((List)caseDataList.get(0), type, name) : null;
        if (result == null) {
            CaseData caseData;
            String uniqueName = existCaseData ? CaseActivityUtils.checkValidName((CaseData)caseDataList.get(0), name) : name;
            result = CaseManagementUtils.createData(type);
            result.setName(uniqueName);
            PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
            if (!bundle.containsKey((Object)uniqueName)) {
                bundle.put((Object)uniqueName, (Object)uniqueName);
            }
            if (existCaseData) {
                caseData = (CaseData)caseDataList.get(0);
            } else {
                caseData = CaseFactory.createCaseData();
                casemgmt.addCaseData(caseData);
            }
            caseData.add((Object)result);
        }
        return result;
    }

    private static String checkValidName(CaseData caseData, String name) {
        Set names = caseData.getNames();
        return CaseFactory.getDefaultName((Set)names, (String)name);
    }

    private static Data findValidCaseDataByNameAndType(List<Data> dataList, CatalogType type, String name) {
        Data result = null;
        for (Data data : dataList) {
            DataType dataType = data.getDataType();
            if (dataType.isSimpleType()) {
                if (!Any.equals(data.getName(), name) || !CaseManagementUtils.isCaseDataTypeAssignable(data, type)) continue;
                result = data;
                break;
            }
            if (!CaseManagementUtils.isCaseDataTypeEquivalent(data, type)) continue;
            result = data;
            break;
        }
        return result;
    }

    private static Output createOutput(String operationName, String endPoint, Sequence<DataDeclaration> arguments, @Nullable Case casemgmt) {
        Output result = CaseActivityFactory.createOutput();
        result.setEndPoint(endPoint);
        result.setOperationName(operationName);
        for (DataDeclaration argument : arguments) {
            CatalogType catalogType = argument.getType();
            TypeDescription typeDescription = catalogType.getDelegate();
            if (typeDescription.hasErrors()) continue;
            SchemaObject schemaObject = typeDescription.asSchemaObject();
            OutputParameter.NormalizedMessage outputParameter = CaseActivityFactory.createNormalizedMessageOutputParameter();
            String paramName = argument.getName();
            String elementName = CaseActivityUtils.getElementName(schemaObject, paramName);
            outputParameter.setParamName(paramName);
            outputParameter.setElementName(elementName);
            outputParameter.setStoreData(true);
            if (casemgmt != null && outputParameter.isStoreData()) {
                Data data = CaseActivityUtils.findOrCreateData(casemgmt, catalogType, argument.getName());
                outputParameter.setDataName(data.getName());
            }
            result.add((Object)outputParameter);
        }
        return result;
    }

    private static String getElementName(SchemaObject schemaObject, String paramName) {
        return schemaObject.isElement() && schemaObject.getQName() != null ? schemaObject.getQName().getLocalPart() : paramName;
    }

    private static boolean isExecData(DataDeclaration dataDeclaration) {
        return EXEC_DATA.equals(dataDeclaration.getName());
    }

    private static boolean isOutcome(DataDeclaration dataDeclaration) {
        return OUTCOME.equals(dataDeclaration.getName());
    }

    private static boolean isDefineInterface(Conversational entryPoint) {
        Conversation conversation = entryPoint.getConversation();
        return conversation != null && conversation.getConversationType().equals((Object)ConversationType.DEFINE_INTERFACE);
    }

    private static boolean isUseInterface(Conversational entryPoint) {
        Conversation conversation = entryPoint.getConversation();
        return conversation != null && conversation.getConversationType().equals((Object)ConversationType.USE_INTERFACE);
    }

    public static class OutputDeclarations {
        private List<Entry> entries = new ArrayList<Entry>();

        public static OutputDeclarations create() {
            return new OutputDeclarations();
        }

        public Entry add(String operationName, String endPoint, Sequence<DataDeclaration> declarations) {
            Entry entry = Entry.create(operationName, endPoint, declarations);
            this.entries.add(entry);
            return entry;
        }

        public Sequence<DataDeclaration> getDeclarations(String operationName, String endPoint) {
            Sequence<DataDeclaration> result = CollectionUtils.asSequence(Collections.emptyList());
            for (Entry entry : this.entries) {
                if (!Any.equals(entry.getEndPoint(), endPoint) || !Any.equals(entry.getOperationName(), operationName)) continue;
                result = entry.getDeclarations();
                break;
            }
            return result;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public static class Entry {
            private final Sequence<DataDeclaration> declarations;
            private final String endPoint;
            private final String operationName;

            public Entry(String operationName, String endPoint, Sequence<DataDeclaration> declarations) {
                this.operationName = operationName;
                this.endPoint = endPoint;
                this.declarations = declarations;
            }

            public static Entry create(String operationName, String endPoint, Sequence<DataDeclaration> declarations) {
                return new Entry(operationName, endPoint, declarations);
            }

            public String getOperationName() {
                return this.operationName;
            }

            public String getEndPoint() {
                return this.endPoint;
            }

            public Sequence<DataDeclaration> getDeclarations() {
                return this.declarations;
            }
        }
    }
}

