/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.io.IOException;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleEntryField;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlTag;
import oracle.bpm.xml.XmlWriter;

public class WeeklySchedule
extends ScheduleEntry {
    private Day dayOfWeek;
    protected static final ScheduleEntryField[] weeklyFieldNames = new ScheduleEntryField[]{ScheduleEntryField.DAY};
    protected static final int fieldCount = weeklyFieldNames.length;

    protected WeeklySchedule(Day dayOfWeek, Interval when) {
        super(when);
        this.dayOfWeek = dayOfWeek;
    }

    public static WeeklySchedule create() {
        return new WeeklySchedule(Day.MONDAY, Interval.ZERO);
    }

    public void setDayOfWeek(Day dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Day getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public ScheduleEntryField getField(int i) {
        return i < fieldCount ? weeklyFieldNames[i] : super.getField(i - fieldCount);
    }

    @Override
    public Class getFieldClass(int i) {
        return i == 0 ? Day.class : super.getFieldClass(i - fieldCount);
    }

    @Override
    public int getFieldCount() {
        return weeklyFieldNames.length + super.getFieldCount();
    }

    @Override
    public void setFieldValue(int i, Object o) {
        if (i == 0) {
            this.dayOfWeek = (Day)o;
        } else {
            super.setFieldValue(i - fieldCount, o);
        }
    }

    @Override
    public Object getFieldValue(int i) {
        return i == 0 ? this.dayOfWeek : super.getFieldValue(i - fieldCount);
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.WEEKLY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeeklySchedule)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WeeklySchedule weeklySchedule = (WeeklySchedule)o;
        return this.dayOfWeek.equals(weeklySchedule.dayOfWeek);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 37 * result + this.dayOfWeek.hashCode();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    protected int compareFields(ScheduleEntry o) {
        WeeklySchedule that = (WeeklySchedule)o;
        int result = this.dayOfWeek == that.dayOfWeek ? 0 : (this.dayOfWeek == null ? -1 : (that.dayOfWeek == null ? 1 : this.dayOfWeek.compareTo(that.dayOfWeek)));
        return result != 0 ? result : super.compareFields(that);
    }

    @Override
    protected boolean equalsFields(ScheduleEntry that) {
        return this.dayOfWeek == ((WeeklySchedule)that).dayOfWeek && super.equalsFields(that);
    }

    @Override
    protected void parse(XmlTag tag) {
        String dayStr = tag.getAttribute(ScheduleEntryField.DAY.getAttributeName());
        if (dayStr != null) {
            this.dayOfWeek = Day.valueOf(dayStr.toUpperCase());
        }
        super.parse(tag);
    }

    @Override
    protected void writeFieldsToXml(XmlWriter xml) throws IOException {
        xml.printAttribute(ScheduleEntryField.DAY.getAttributeName(), this.dayOfWeek);
        super.writeFieldsToXml(xml);
    }
}

