/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.DailySchedule;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.WeeklySchedule;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ScheduleType implements I18nProvider
{
    DAILY(LibMsg.DAILY){

        @Override
        public DailySchedule createSchedule() {
            return DailySchedule.create();
        }
    }
    ,
    WEEKLY(LibMsg.WEEKLY){

        @Override
        public WeeklySchedule createSchedule() {
            return WeeklySchedule.create();
        }
    }
    ,
    MONTHLY(LibMsg.MONTHLY){

        @Override
        public MonthlySchedule createSchedule() {
            return MonthlySchedule.create();
        }
    };

    private transient Msg msg;

    private ScheduleType(Msg msg) {
        this.msg = msg;
    }

    public ScheduleEntry createSchedule() {
        return DailySchedule.create();
    }

    public static ScheduleType compatibleValueOf(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int index = Integer.parseInt(name);
            ScheduleType[] types = ScheduleType.values();
            return index >= 0 && index < types.length ? types[index] : DAILY;
        }
        return ScheduleType.valueOf(name);
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }
}

