/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.project.model.DailySchedule;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.WeeklySchedule;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class Schedule {
    private List<DailySchedule> dailyEntries = new ArrayList<DailySchedule>();
    private List<MonthlySchedule> monthlyEntries = new ArrayList<MonthlySchedule>();
    private List<WeeklySchedule> weeklyEntries = new ArrayList<WeeklySchedule>();

    public boolean add(ScheduleEntry se) {
        switch (se.getType()) {
            case DAILY: {
                this.dailyEntries.add((DailySchedule)se);
                break;
            }
            case WEEKLY: {
                this.weeklyEntries.add((WeeklySchedule)se);
                break;
            }
            case MONTHLY: {
                this.monthlyEntries.add((MonthlySchedule)se);
            }
        }
        return true;
    }

    public boolean remove(ScheduleEntry se) {
        switch (se.getType()) {
            case DAILY: {
                this.dailyEntries.remove(se);
                break;
            }
            case WEEKLY: {
                this.weeklyEntries.remove(se);
                break;
            }
            case MONTHLY: {
                this.monthlyEntries.remove(se);
            }
        }
        return true;
    }

    public void clearAll() {
        this.dailyEntries.clear();
        this.weeklyEntries.clear();
        this.monthlyEntries.clear();
    }

    public ScheduleType getType() {
        if (this.weeklyEntries.size() > 0) {
            return ScheduleType.WEEKLY;
        }
        if (this.monthlyEntries.size() > 0) {
            return ScheduleType.MONTHLY;
        }
        return ScheduleType.DAILY;
    }

    public List<DailySchedule> getDailyEntries() {
        return Collections.unmodifiableList(this.dailyEntries);
    }

    public List<WeeklySchedule> getWeeklyEntries() {
        return Collections.unmodifiableList(this.weeklyEntries);
    }

    public List<MonthlySchedule> getMonthlyEntries() {
        return Collections.unmodifiableList(this.monthlyEntries);
    }

    public List<ScheduleEntry> getAllEntries() {
        LinkedList<ScheduleEntry> allEntries = new LinkedList<ScheduleEntry>();
        allEntries.addAll(this.dailyEntries);
        allEntries.addAll(this.weeklyEntries);
        allEntries.addAll(this.monthlyEntries);
        return allEntries;
    }

    public ScheduleEntry get(ScheduleType type, int index) {
        switch (type) {
            case DAILY: {
                return this.dailyEntries.get(index);
            }
            case WEEKLY: {
                return this.weeklyEntries.get(index);
            }
            case MONTHLY: {
                return this.monthlyEntries.get(index);
            }
        }
        return null;
    }

    public List<? extends ScheduleEntry> getEntries(ScheduleType scheduleType) {
        switch (scheduleType) {
            case DAILY: {
                return this.getDailyEntries();
            }
            case WEEKLY: {
                return this.getWeeklyEntries();
            }
        }
        return this.getMonthlyEntries();
    }

    public void remove(ScheduleType type, int index) {
        switch (type) {
            case DAILY: {
                this.dailyEntries.remove(index);
                break;
            }
            case WEEKLY: {
                this.weeklyEntries.remove(index);
                break;
            }
            case MONTHLY: {
                this.monthlyEntries.remove(index);
            }
        }
    }

    public int size(ScheduleType type) {
        switch (type) {
            case DAILY: {
                return this.dailyEntries.size();
            }
            case WEEKLY: {
                return this.weeklyEntries.size();
            }
            case MONTHLY: {
                return this.monthlyEntries.size();
            }
        }
        return 0;
    }

    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Deprecated
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.SCHEDULE;
    }
}

