/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectList<P extends ProjectObject>
extends ArrayList<P> {
    private static final long serialVersionUID = -8300679617696563574L;

    public ProjectObjectList() {
    }

    public ProjectObjectList(Collection<P> collection) {
        super(collection);
    }

    public Sequence<P> asSequence() {
        return CollectionUtils.asSequence(this);
    }

    @NotNull
    public <T extends ProjectObject> Sequence<T> byType(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (ProjectObject element : this) {
            if (!type.isAssignableFrom(element.getRawClass())) continue;
            result.add(type.cast(element));
        }
        return CollectionUtils.asSequence(result);
    }

    public <T extends ProjectObject> T byTypeAndId(Class<T> type, String id) {
        ProjectObject result = null;
        for (ProjectObject element : this) {
            if (!type.isAssignableFrom(element.getRawClass()) || !element.getId().equals(id)) continue;
            result = (ProjectObject)type.cast(element);
            break;
        }
        return (T)result;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if (object != this.get(i)) continue;
            return i;
        }
        return super.indexOf(object);
    }

    public ProjectObjectList<P> copy() {
        return new ProjectObjectList<P>(this);
    }

    @Override
    public boolean add(P e) {
        return e != null && super.add(e);
    }

    @Override
    public void add(int index, P element) {
        super.add(index, element);
    }
}

