/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.model.CompiledProject;
import oracle.bpm.project.model.CorrelationModel;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectGenerateEvents;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.ResourceManager;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.AnnotationsEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Project
extends ResourceContainer,
AnnotationsEnabled,
DataDeclarationContainer,
CorrelationModel {
    @Override
    public String getName();

    public FolderContainer getModelsRoot();

    @Nullable
    public CaseContainer getCaseContainer();

    @Nullable
    public ProjectCase getCase();

    public Collection<Process> getProcesses();

    @Deprecated
    public List<TypeRef> getBusinessCatalog() throws ProjectException;

    public void addProcess(Process var1) throws ProjectException;

    public Organization getOrganization();

    public void setLoader(ProjectLoader var1);

    @Nullable
    public ProjectLoader getLoader();

    public void setWriter(ProjectWriter var1);

    public ProjectWriter getWriter();

    public ComponentCatalog getComponentCatalog();

    public CatalogModule getCatalogRoot();

    @NotNull
    public CatalogType getCatalogType(@NotNull TypeRef var1);

    public CatalogObject findCatalogObject(@NotNull String var1) throws AmbiguousTypeNameException;

    public CatalogObject findCatalogObject(@NotNull String var1, boolean var2) throws AmbiguousTypeNameException;

    public CatalogObject findSchemaElement(@NotNull XmlElementType var1, @NotNull String var2, @NotNull String var3);

    public CompiledProject compile() throws ProjectException;

    public Process findProcess(String var1);

    public Locale getDefaultLanguage();

    public Collection<Locale> getAvailableLanguages();

    public ProjectPreferences getPreferences();

    public void addProjectPreferences(ProjectPreferences var1) throws ProjectException;

    public void removeProjectPreferences() throws ProjectException;

    public ProjectPreferences createProjectPreferences(String var1);

    public void dispose() throws ProjectException;

    public void setComponentCatalog(ComponentCatalog var1);

    public CatalogObject createCatalogObject(TypeRef var1);

    public Process getProjectModel();

    public Sequence<ProjectDataObject> getProjectDataObjects();

    public ProjectDataObject findDataObject(String var1);

    @Override
    public ProjectDataObject createDeclaration(String var1, CatalogType var2) throws ProjectException;

    @Override
    public ProjectDataObject createDeclaration(String var1, CatalogType var2, AccessType var3) throws ProjectException;

    public boolean isOpen();

    public void setOpen(boolean var1);

    public SimulationsContainer getSimulations();

    public ActivityGuide getActivityGuide();

    @NotNull
    public ResourceFilesContainer getResourceFilesContainer();

    public boolean isTemplate();

    public ProjectGenerateEvents getGenerateEvents();

    public Sequence<ProjectDataObject> getBusinessIndicators();

    @NotNull
    public ResourceManager getResourceManager();

    public <T extends ProjectObject> T createFromXml(Class<T> var1, String var2) throws ProjectException;

    public ProjectRepository getRepository();

    public Sequence<ProjectDataObject> getBusinessIndicatorsByType(BusinessVariableType var1);

    public String getProjectNamespace();
}

