/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.io.File;
import java.util.ArrayList;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NonNls;

public class Path {
    private final String name;
    private final Path parent;
    public static final String PATH_SEPARATOR = "/";
    public static final Path ROOT = Path.create(null, "");
    public static final Path PROCESSES = ROOT.create("processes");
    public static final Path RESOURCES = ROOT.create("resources");
    public static final Path SIMULATIONS = ROOT.create("simulations");
    public static final Path BUSINESS_CATALOG = ROOT.create("businessCatalog");
    public static final Path ACTIVITY_GUIDES = ROOT.create("activityGuides");
    public static final Path XSL = ROOT.create("xsl");
    public static final Path XSD = ROOT.create("xsd");
    public static final Path CASE = ROOT.create("case");
    public static final Path CASE_ACTIVITIES = CASE.create("activities");
    public static final Path BUILD = ROOT.create("build");
    public static final Path BUILD_CATALOG = BUILD.create("catalog");
    public static final Path BUILD_PROCESSES = BUILD.create("processes");
    public static final Path LIB = ROOT.create("lib");
    public static final Path SYSTEM = ROOT.create("system");
    public static final Path SYSTEM_CONFIG = SYSTEM.create("config");
    public static final Path SYSTEM_OUTPUT = SYSTEM.create("output");
    public static final Path CONFIG = ROOT.create("config");
    public static final Path PREFERENCES = Path.create(CONFIG, "preferences");
    public static final Path EXTERNAL_RESOURCES = CONFIG.create("externalResources");
    public static final Path ORGANIZATION = CONFIG.create("organization");
    public static final Path BUSINESS_PARAMETER = ROOT.create("businessParameter");
    public static final Path ROLE = ORGANIZATION.create("role");
    public static final Path ORGANIZATIONAL_UNIT = ORGANIZATION.create("ou");
    public static final Path GROUP = ORGANIZATION.create("group");
    public static final Path PARTICIPANT = ORGANIZATION.create("participant");
    public static final Path HOLIDAY = ORGANIZATION.create("holiday");
    public static final Path CALENDAR = ORGANIZATION.create("calendar");
    public static final Path VARIABLE = ORGANIZATION.create("variable");
    public static final Path ORGANIZATIONAL_CHART = ORGANIZATION.create("organizationalChart");
    public static final Path PROJECT_RESOURCES = ROOT.create("resources");
    public static final Path PROJECT_RUNTIME_RESOURCES = PROJECT_RESOURCES.create("runtime");
    public static final Path SIMULATIONS_DEFINITIONS = SIMULATIONS.create("definitions");
    public static final Path SIMULATIONS_MODELS = SIMULATIONS.create("models");

    private Path(Path parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public static Path create(Path base, @NonNls String name) {
        return new Path(base, name);
    }

    public static Path createFromVFile(VFile file) {
        ArrayList<String> list = new ArrayList<String>();
        for (VFile filePart = file; filePart != filePart.getFileSystem().getRoot(); filePart = filePart.getParentFile()) {
            list.add(0, filePart.getName());
        }
        Path result = ROOT;
        for (String part : list) {
            result = result.create(part);
        }
        return result;
    }

    public static int count(Path path) {
        return path.getParts().length;
    }

    public static Path getPath(File file) {
        Object[] fileParts = FileUtils.getParts(file).toArray();
        Path path = Path.create(ROOT, (String)fileParts[0]);
        for (int i = 1; i < fileParts.length; ++i) {
            path = Path.create(path, (String)fileParts[i]);
        }
        return path;
    }

    public Path create(@NonNls String name) {
        return Path.create(this, name);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String[] getParts() {
        ArrayList<String> list = new ArrayList<String>();
        Path path = this;
        while (!path.isRoot()) {
            list.add(0, path.getName());
            path = path.getParent();
        }
        return list.toArray(new String[list.size()]);
    }

    public String getFirst() {
        return this.getParts()[0];
    }

    public Path getParent() {
        return this.parent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.toString().equals(((Path)other).toString());
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 29 * result + this.getName().hashCode();
        return result;
    }

    public String toString() {
        String result;
        if (this.isRoot()) {
            result = "";
        } else {
            String[] parts = this.getParts();
            StringBuffer buf = new StringBuffer();
            buf.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                buf.append(PATH_SEPARATOR);
                buf.append(parts[i]);
            }
            result = buf.toString();
        }
        return result;
    }

    public boolean isPrefixOf(Path path) {
        return path.toString().startsWith(this.toString());
    }

    public String getName() {
        return this.name;
    }

    public File getFile(File parent) {
        return this.getFile(parent, "");
    }

    public File getFile(File parent, String extension) {
        String[] parts = this.getParts();
        File result = parent;
        for (int i = 0; i < parts.length - 1; ++i) {
            result = new File(result, parts[i]);
        }
        result = new File(result, parts[parts.length - 1] + extension);
        return result;
    }

    public VFile getVFile(VFile parent) {
        String[] parts = this.getParts();
        VFile result = parent;
        VFileSystem fs = parent.getFileSystem();
        for (String part : parts) {
            result = fs.createFile(result, part);
        }
        return result;
    }
}

