/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.changeset;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Ref;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class ModelChangeSet {
    private final Ref<Point> absolute;
    private final List<ModelChange> changeSet = new ArrayList<ModelChange>();
    private final List<ModelChangeSet> children = new ArrayList<ModelChangeSet>(3);

    public ModelChangeSet() {
        this.absolute = Ref.createRef(Point.ORIGIN);
    }

    public ModelChangeSet(@NotNull Ref<Point> absolute) {
        this.absolute = absolute;
    }

    public ModelChangeSet apply(@NotNull Process model) throws ProjectException {
        ModelChangeSet backup = new ModelChangeSet();
        for (ModelChangeSet child : this.children) {
            backup.add(child.apply(model));
        }
        for (ModelChange change : this.changeSet) {
            backup.add(change.apply(model));
        }
        return backup;
    }

    public Sequence<ModelChange> getModelChanges() {
        ArrayList<ModelChange> result = new ArrayList<ModelChange>();
        for (ModelChange change : this.changeSet) {
            result.add(change);
        }
        for (ModelChangeSet modelChange : this.children) {
            modelChange.getModelChanges().addAllTo(result);
        }
        return CollectionUtils.asSequence(result);
    }

    public void addRemoveLane(@NotNull Lane lane) {
        this.add(new RemoveLane(lane));
    }

    public void addAddLane(@NotNull Lane lane) {
        this.add(new AddLane(lane));
    }

    public void addChangeSubprocess(@NotNull Subprocess subprocess, @NotNull Point location, @NotNull Dimension size, @NotNull ModelChangeSet innerChanges) {
        this.addChangeSubprocess(subprocess, location, size, innerChanges, true);
    }

    public void addChangeSubprocess(@NotNull Subprocess subprocess, @NotNull Point location, @NotNull Dimension size, @NotNull ModelChangeSet innerChanges, boolean usesAbsoluteLocations) {
        this.add(innerChanges);
        if (usesAbsoluteLocations) {
            innerChanges.updateInnerAbsoluteLocations(location.sub(size.getWidth() / 2, size.getHeight() / 2));
        }
        this.add(new ChangeSubprocess(subprocess, location, size, this.absolute));
    }

    public void addChangeActivity(@NotNull FlowNode node, @NotNull Lane lane, @NotNull Point location) {
        if (node.getLane() != null && !node.getLane().equals(lane) || !node.getLocation().equals(location)) {
            this.add(new ChangeActivity(node, lane, location, this.absolute));
        }
    }

    public void addChangeLane(@NotNull Lane lane, int offset, int size) {
        if (lane.getOffset() != offset || lane.getSize() != size) {
            this.add(new ChangeLane(lane, offset, size));
        }
    }

    public void addChangeTransition(@NotNull SequenceFlow transition, @NotNull Point controlPoint) {
        if (!transition.getControlPoint().equals(controlPoint)) {
            this.add(new ChangeTransition(transition, controlPoint, this.absolute));
        }
    }

    public void addChangeMeasurement(@NotNull Measurement measurement, @NotNull Point location) {
        if (!measurement.getLocation().equals(location)) {
            this.add(new ChangeMeasurement(measurement, location, this.absolute));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Builder Structure \n").append("Children: ").append(this.children.size()).append("\nInner Changes: ").append(this.changeSet.size()).append("\n");
        builder.append("CHANGE SET\n");
        for (ModelChange change : this.changeSet) {
            builder.append(change);
            builder.append('\n');
        }
        builder.append("CHILDREN\n");
        for (ModelChangeSet child : this.children) {
            builder.append(child);
            builder.append('\n');
        }
        return builder.toString();
    }

    private void add(ModelChange change) {
        this.changeSet.add(change);
    }

    private void add(ModelChangeSet changes) {
        this.children.add(changes);
    }

    private void updateInnerAbsoluteLocations(@NotNull Point point) {
        this.absolute.set(this.absolute.get().add(point));
        for (ModelChangeSet child : this.children) {
            child.updateInnerAbsoluteLocations(point);
        }
    }

    private static class RemoveLane
    extends LaneModelChange {
        private RemoveLane(@NotNull Lane lane) {
            super(lane, Operation.REMOVE);
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            Lane lane = (Lane)this.getModel();
            AddLane backup = new AddLane(lane);
            model.removeChild(lane);
            return backup;
        }
    }

    private static class ChangeTransition
    extends AbsoluteModelChange<SequenceFlow> {
        @NotNull
        private Point controlPoint;

        private ChangeTransition(@NotNull SequenceFlow transition, @NotNull Point controlPoint, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.TRANSITION, transition, absolute);
            this.controlPoint = controlPoint;
        }

        @Override
        public String toString() {
            SequenceFlow transition = (SequenceFlow)this.getModel();
            return this.changeString(ChangeTransition.string(transition.getControlPoint()), ChangeTransition.string(!this.controlPoint.equals(SequenceFlow.NULL_CONTROL_POINT) ? this.relToAbs(this.controlPoint) : this.controlPoint));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            SequenceFlow transition = (SequenceFlow)this.getModel();
            ChangeTransition backup = new ChangeTransition(transition, transition.getControlPoint(), Ref.createRef(Point.ORIGIN));
            transition.setRoutingData(transition.getRoutingMode(), !this.controlPoint.equals(SequenceFlow.NULL_CONTROL_POINT) ? this.relToAbs(this.controlPoint) : this.controlPoint);
            return backup;
        }

        private static String string(Point cp) {
            return cp.equals(SequenceFlow.NULL_CONTROL_POINT) ? "[]" : cp.toString();
        }
    }

    private static class ChangeSubprocess
    extends AbsoluteModelChange<Subprocess> {
        @NotNull
        private final Point location;
        @NotNull
        private final Dimension size;

        private ChangeSubprocess(@NotNull Subprocess subprocess, @NotNull Point location, @NotNull Dimension size, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.ACTIVITY, subprocess, absolute);
            this.size = size;
            this.location = location;
        }

        @Override
        public String toString() {
            Subprocess subprocess = (Subprocess)this.getModel();
            return this.changeString(ChangeSubprocess.string(subprocess.getLocation(), Dimension.valueOf(subprocess.getWidth(), subprocess.getHeight())), ChangeSubprocess.string(this.relToAbs(this.location), this.size));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            Subprocess subprocess = (Subprocess)this.getModel();
            ChangeSubprocess backup = new ChangeSubprocess(subprocess, subprocess.getLocation(), Dimension.valueOf(subprocess.getWidth(), subprocess.getHeight()), Ref.createRef(Point.ORIGIN));
            subprocess.setWidth(this.size.getWidth());
            subprocess.setHeight(this.size.getHeight());
            subprocess.setLocation(this.relToAbs(this.location));
            return backup;
        }

        private static String string(Point location, Dimension size) {
            return location + " with size " + size;
        }
    }

    private static class ChangeMeasurement
    extends AbsoluteModelChange<Measurement> {
        @NotNull
        private Point location;

        private ChangeMeasurement(@NotNull Measurement measurement, @NotNull Point location, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.MEASUREMENT, measurement, absolute);
            this.location = location;
        }

        @Override
        public String toString() {
            Measurement measurement = (Measurement)this.getModel();
            return this.changeString(measurement.getLocation().toString(), this.relToAbs(this.location).toString());
        }

        @Override
        protected ModelChange apply(@NotNull Process process) throws ProjectException {
            Measurement measurement = (Measurement)this.getModel();
            ChangeMeasurement backup = new ChangeMeasurement(measurement, measurement.getLocation(), Ref.createRef(Point.ORIGIN));
            measurement.setLocation(this.relToAbs(this.location));
            return backup;
        }
    }

    private static class ChangeLane
    extends LaneModelChange {
        private int offset;
        private int size;

        private ChangeLane(@NotNull Lane lane, int offset, int size) {
            super(lane, Operation.CHANGE);
            this.offset = offset;
            this.size = size;
        }

        @Override
        public String toString() {
            Lane lane = (Lane)this.getModel();
            return this.changeString(ChangeLane.string(lane.getOffset(), lane.getSize()), ChangeLane.string(this.offset, this.size));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            Lane lane = (Lane)this.getModel();
            ChangeLane backup = new ChangeLane(lane, lane.getOffset(), lane.getSize());
            Lane l = lane;
            l.setOffset(this.offset);
            l.setSize(this.size);
            return backup;
        }

        private static String string(int pos, int sz) {
            return new Point(pos, sz).toString();
        }
    }

    private static class ChangeActivity
    extends AbsoluteModelChange<FlowNode> {
        @NotNull
        private Lane lane;
        @NotNull
        private Point location;

        private ChangeActivity(@NotNull FlowNode node, @NotNull Lane lane, @NotNull Point location, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.ACTIVITY, node, absolute);
            this.lane = lane;
            this.location = location;
        }

        @Override
        public String toString() {
            FlowNode node = (FlowNode)this.getModel();
            return this.changeString(ChangeActivity.string(node.getLane(), node.getLocation(), node.getBpmnType()), ChangeActivity.string(this.lane, this.relToAbs(this.location), node.getBpmnType()));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            FlowNode node = (FlowNode)this.getModel();
            ChangeActivity backup = new ChangeActivity(node, node.getLane(), node.getLocation(), Ref.createRef(Point.ORIGIN));
            node.setLocation(this.relToAbs(this.location));
            return backup;
        }

        private static String string(Lane l, Point loc, BpmnType type) {
            return l.getId() + " " + loc + " for " + type;
        }
    }

    private static class AddLane
    extends LaneModelChange {
        private AddLane(@NotNull Lane lane) {
            super(lane, Operation.ADD);
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            Lane lane = (Lane)this.getModel();
            model.addChild(lane);
            return new RemoveLane(lane);
        }
    }

    private static abstract class LaneModelChange
    extends ModelChange<Lane> {
        private LaneModelChange(@NotNull Lane lane, @NotNull Operation operation) {
            super(ProjectObjectType.LANE, lane, operation);
        }
    }

    private static abstract class AbsoluteModelChange<E extends FlowElement>
    extends ModelChange<E> {
        private final Ref<Point> absolute;

        public AbsoluteModelChange(@NotNull ProjectObjectType type, E affectedObject, @NotNull Ref<Point> absolute) {
            super(type, affectedObject);
            this.absolute = absolute;
        }

        protected Point relToAbs(@NotNull Point relative) {
            return relative.add(this.absolute.get());
        }
    }

    public static abstract class ModelChange<E extends FlowElement> {
        final E model;
        final Operation operation;
        final ProjectObjectType type;

        public ModelChange(ProjectObjectType type, E model) {
            this(type, model, Operation.CHANGE);
        }

        public ModelChange(ProjectObjectType type, E model, Operation operation) {
            this.type = type;
            this.model = model;
            this.operation = operation;
        }

        public E getModel() {
            return this.model;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            return this.changeString();
        }

        protected abstract ModelChange apply(@NotNull Process var1) throws ProjectException;

        protected String changeString() {
            return (Object)((Object)this.operation) + " " + (Object)((Object)this.type) + "(" + this.getModel().getId() + ")";
        }

        protected String changeString(String before, String after) {
            return this.changeString() + " " + before + " -> " + after;
        }
    }

    public static enum Operation {
        ADD,
        CHANGE,
        REMOVE;


        public String toString() {
            return this.name().substring(0, 1);
        }
    }
}

