/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.ObjectClassInstance;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.utils.BackwardsCompatibilitySupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectClassInstanceQuery
implements BackwardsCompatibilitySupport<Implementation> {
    private static ObjectClassInstanceQuery instance = new ObjectClassInstanceQuery();
    private static final String IMPLEMENTATION_11G = "oracle.bpm.papi.ora.layout.ObjectClassInstanceQuery11G";

    public static List<ObjectClassInstance> findObjectClassBySession(@NotNull ProcessServiceSession session, @NotNull String objectClass) throws OperationException {
        return ObjectClassInstanceQuery.getInstance().getImplementation(session).findObjectClassBySession(session, objectClass);
    }

    @Override
    public Implementation getImplementation(@NotNull ProcessServiceSession session) throws OperationException {
        return BackwardsCompatibilitySupport.Utils.loadImplementation(this, session);
    }

    @Override
    public String getImplementationClassName(@NotNull ProcessServiceSession session) {
        if (session.getClass().getName().equals("oracle.bpm.papi.ora.ProcessServiceSessionAdapter")) {
            return IMPLEMENTATION_11G;
        }
        return "fuego.papi.utils.ObjectClassInstanceQuery.PapiImplementation";
    }

    private static ObjectClassInstanceQuery getInstance() {
        return instance;
    }

    private static class PapiImplementation
    implements Implementation {
        @Override
        public List<ObjectClassInstance> findObjectClassBySession(ProcessServiceSession session, String objectClass) throws OperationException {
            String[] participants = new String[]{session.participantCurrent().getUid()};
            String[] roles = session.participantCurrent().getRoles();
            ObjectClassInstance[] objectClassInstances = session.objectClassInstanceFetchByRolesAndParticipants(objectClass, roles, participants);
            if (objectClassInstances != null && objectClassInstances.length > 0) {
                return Arrays.asList(objectClassInstances);
            }
            return new ArrayList<ObjectClassInstance>();
        }
    }

    public static interface Implementation {
        public List<ObjectClassInstance> findObjectClassBySession(ProcessServiceSession var1, String var2) throws OperationException;
    }
}

