/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.collections;

import fuego.papi.InstanceInfo;
import fuego.papi.collections.ElementIdSet;
import fuego.papi.collections.InstanceActivityPair;
import fuego.papi.collections.InstanceInfoList;
import java.util.Iterator;
import java.util.SortedMap;
import oracle.bpm.collections.iterator.ReadOnlyIterator;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.SortedStringMap;

public class InstanceActivityPairSet
implements ElementIdSet<InstanceActivityPair> {
    private SortedMap<String, InstanceActivityPair> items = SortedStringMap.createCaseInsensitive();
    static final long serialCheck = 6916300086119082743L;
    static final long serialVersionUID = -6211159131097546498L;

    private InstanceActivityPairSet() {
    }

    public static InstanceActivityPairSet create() {
        return new InstanceActivityPairSet();
    }

    public InstanceActivityPairSet add(String instanceId, String activityName) {
        this.items.put(instanceId, new InstanceActivityPair(instanceId, activityName));
        return this;
    }

    public InstanceActivityPairSet addAll(InstanceActivityPair ... items) {
        for (InstanceActivityPair item : items) {
            this.items.put(item.getInstanceId(), item);
        }
        return this;
    }

    @Override
    public ElementIdSet<InstanceActivityPair> add(InstanceActivityPair instanceActivityPair) {
        this.items.put(instanceActivityPair.getInstanceId(), instanceActivityPair);
        return this;
    }

    @Override
    public ElementIdSet<InstanceActivityPair> addAll(ElementIdSet<InstanceActivityPair> instanceActivityPairSet) {
        for (InstanceActivityPair instanceActivityPair : instanceActivityPairSet) {
            this.add(instanceActivityPair);
        }
        return this;
    }

    @Override
    public Iterator<InstanceActivityPair> iterator() {
        return ReadOnlyIterator.create(this.items.values().iterator());
    }

    public Iterable<String> instanceIds() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return ReadOnlyIterator.create(InstanceActivityPairSet.this.items.keySet().iterator());
            }
        };
    }

    public StringList getInstanceIdList() {
        StringList stringList = StringList.create(this.items.size());
        stringList.addAll(this.items.keySet());
        return stringList;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(String instanceId) {
        return this.items.containsKey(instanceId);
    }

    @Override
    public boolean contains(InstanceActivityPair instanceActivityPair) {
        return this.contains(instanceActivityPair.getInstanceId());
    }

    public InstanceActivityPairSet add(InstanceInfo instance) {
        this.add(instance.getId(), instance.getActivityName());
        return this;
    }

    public InstanceActivityPairSet addAll(InstanceInfo ... instances) {
        for (InstanceInfo instance : instances) {
            this.add(instance);
        }
        return this;
    }

    public InstanceActivityPairSet addAll(InstanceInfoList instances) {
        for (InstanceInfo instance : instances) {
            this.add(instance);
        }
        return this;
    }

    public String getActivity(String instanceId) {
        return ((InstanceActivityPair)this.items.get(instanceId)).getActivityName();
    }

    public InstanceActivityPair[] toArray() {
        return this.items.values().toArray(new InstanceActivityPair[this.items.size()]);
    }
}

