/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.attachment.config;

import fuego.papi.exception.AttachmentConfigException;
import fuego.papi.msg.PapiMsg;

public class MappingCredentials {
    private String password;
    private String username;
    private static final String SEPARATOR = ":";

    public MappingCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static MappingCredentials createFromString(String credentials) {
        if (credentials == null || !credentials.contains(SEPARATOR)) {
            throw new AttachmentConfigException(PapiMsg.PAPI_11081);
        }
        if (credentials.indexOf(SEPARATOR) == credentials.length() - 1) {
            throw new AttachmentConfigException(PapiMsg.PAPI_11081);
        }
        String username = credentials.substring(0, credentials.indexOf(SEPARATOR));
        String password = credentials.substring(credentials.indexOf(SEPARATOR) + 1, credentials.length());
        return new MappingCredentials(username, password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.username + SEPARATOR + this.password;
    }
}

