/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.VarUtils;
import org.jetbrains.annotations.NonNls;

@Component(module="Fuego.Papi")
public class VarDefinition
implements Serializable {
    private boolean hasRanges = false;
    private boolean isAttribute = false;
    private boolean isCounter = false;
    private boolean isDefault_d;
    private boolean isDimension = false;
    private boolean isMeasure = false;
    private LocaleStringMap labels = LocaleStringMap.create();
    private transient Msg msgLabels = null;
    private List<Range> ranges = new ArrayList<Range>();
    private int variableFractionSize_d;
    private String variableId_d;
    private int variableKind_d;
    private String variableMask_d;
    private int variableSize_d;
    @NonNls
    private static final String NO_MASK = "MASK";
    @NonNls
    private static final String DESCRIPTION_DB = "name";
    @NonNls
    private static final String STATUS_DB = "state";
    @NonNls
    private static final String PRIORITY_DB = "priority";
    @NonNls
    private static final String RECEIVED_DB = "receiveTime";
    @NonNls
    private static final String PROCESS_DEADLINE_DB = "processDeadline";
    @NonNls
    private static final String ACTIVITY_DEADLINE_DB = "activityDeadline";
    @NonNls
    private static final String ACTIVITY_DB = "activityName";
    @NonNls
    private static final String PARTICIPANT_DB = "participant";
    @NonNls
    private static final String COPY_DB = "threadId";
    @NonNls
    private static final String TASK_DB = "Task";
    @NonNls
    private static final String NAME_DB = "att_name";
    @NonNls
    private static final String CREATOR_DB = "Creator";
    @NonNls
    private static final String VERSION_DB = "Version";
    @NonNls
    private static final String FILENAME_DB = "Filename";
    @NonNls
    private static final String LOCKER_DB = "Locker";
    @NonNls
    private static final String SIZE_DB = "Size";
    @NonNls
    private static final String AUTHOR_DB = "author";
    @NonNls
    private static final String CREATION_TIME_DB = "creationTime";
    @NonNls
    private static final String PROCESS_DB = "processid";
    @NonNls
    private static final String INSTANCE_NUMBER_DB = "instId";
    @NonNls
    private static final String PARENT_COPY_DB = "parentThread";
    @ReplacementFor(value="descriptionid")
    @NonNls
    public static final String DESCRIPTION_ID = "PREDEFINE_DESCRIPTION";
    @ReplacementFor(value="statusid")
    @NonNls
    public static final String STATUS_ID = "PREDEFINE_STATUS";
    @ReplacementFor(value="priorityid")
    @NonNls
    public static final String PRIORITY_ID = "PREDEFINE_PRIORITY";
    @ReplacementFor(value="deadlineid")
    @NonNls
    public static final String DEADLINE_ID = "PREDEFINE_DEADLINE";
    @ReplacementFor(value="documentationid")
    @NonNls
    public static final String DOCUMENTATION_ID = "PREDEFINE_DOCUMENTATION";
    @ReplacementFor(value="receivedid")
    @NonNls
    public static final String RECEIVED_ID = "PREDEFINE_RECEIVED TIME";
    @ReplacementFor(value="processdeadlineid")
    @NonNls
    public static final String PROCESS_DEADLINE_ID = "PREDEFINE_PROCESS DEADLINE";
    @ReplacementFor(value="activitydeadlineid")
    @NonNls
    public static final String ACTIVITY_DEADLINE_ID = "PREDEFINE_ACTIVITY DEADLINE";
    @ReplacementFor(value="processid")
    @NonNls
    public static final String PROCESS_ID = "PREDEFINE_PROCESS";
    @ReplacementFor(value="activityid")
    @NonNls
    public static final String ACTIVITY_ID = "PREDEFINE_ACTIVITY";
    @ReplacementFor(value="participantid")
    @NonNls
    public static final String PARTICIPANT_ID = "PREDEFINE_PARTICIPANT";
    @ReplacementFor(value="copyid")
    @NonNls
    public static final String COPY_ID = "PREDEFINE_COPY";
    @ReplacementFor(value="taskid")
    @NonNls
    public static final String TASK_ID = "PREDEFINE_TASK";
    @ReplacementFor(value="authorid")
    @NonNls
    public static final String AUTHOR_ID = "PREDEFINE_AUTHOR";
    @NonNls
    public static String AUTHOR_DISPLAYNAME = "PREDEFINE_AUTHOR_DISPLAYNAME";
    @ReplacementFor(value="creationtimeid")
    @NonNls
    public static final String CREATION_TIME_ID = "PREDEFINE_CREATION TIME";
    @NonNls
    public static final String PARENT_COPY_ID = "PREDEFINE_PARENT COPY";
    @ReplacementFor(value="instancenumber")
    @NonNls
    public static final String INSTANCE_NUMBER = "PREDEFINE_INSTANCE NUMBER";
    @ReplacementFor(value="tasknumber")
    @NonNls
    public static final String TASK_NUMBER = "PREDEFINE_TASK NUMBER";
    @ReplacementFor(value="nameid")
    @NonNls
    public static final String NAME_ID = "PREDEFINE_NAME";
    @ReplacementFor(value="creatorid")
    @NonNls
    public static final String CREATOR_ID = "PREDEFINE_CREATOR";
    @ReplacementFor(value="versionid")
    @NonNls
    public static final String VERSION_ID = "PREDEFINE_VERSION";
    @ReplacementFor(value="filenameid")
    @NonNls
    public static final String FILENAME_ID = "PREDEFINE_FILE NAME";
    @ReplacementFor(value="lockerid")
    @NonNls
    public static final String LOCKER_ID = "PREDEFINE_LOCKER";
    @ReplacementFor(value="sizeid")
    @NonNls
    public static final String SIZE_ID = "PREDEFINE_SIZE";
    @ReplacementFor(value="hasattachments")
    @NonNls
    public static final String HAS_ATTACHMENTS = "PREDEFINE_HAS_ATTACHMENTS";
    @NonNls
    public static String HAS_NOTES = "PREDEFINE_HAS_NOTES";
    @NonNls
    public static String MAIN_TASK_PARTICIPANT_ID = "PREDEFINE_MAIN_TASK_PARTICIPANT_ID";
    private static VarDefinition[] instanceDefaults_d = null;
    private static VarDefinition[] applicationDefaults_d = null;
    private static VarDefinition[] attachmentDefaults_d = null;
    @Exclude
    static final long serialCheck = -815660036313833626L;
    @Exclude
    static final long serialVersionUID = 1000002022515300101L;
    private static Map<String, String> dbColumnMap = new HashMap<String, String>();

    @Exclude
    public VarDefinition(String varId, int varKind, String varMask, int varSize, LocaleStringMap labels) {
        this(varId, varKind, varMask, varSize, 0, false, false, false, labels, false, null);
    }

    @Exclude
    public VarDefinition(String varId, int varKind, String varMask, int varSize, int varFractionSize, boolean isMeasure, boolean isDimension, LocaleStringMap varLabels) {
        this(varId, varKind, varMask, varSize, varFractionSize, isMeasure, isDimension, false, varLabels, false, null);
    }

    @Exclude
    public VarDefinition(String varId, int varKind, String varMask, int varSize, int varFractionSize, boolean isMeasure, boolean isDimension, boolean isCounter, LocaleStringMap labels, boolean hasRanges, List<Range> ranges) {
        this(varId, varKind, varMask, varSize, varFractionSize, isMeasure, isDimension, isCounter, false, labels, hasRanges, ranges);
    }

    @Exclude
    public VarDefinition(String varId, int varKind, String varMask, int varSize, int varFractionSize, boolean isMeasure, boolean isDimension, boolean isCounter, boolean isAttribute, LocaleStringMap labels, boolean hasRanges, List<Range> ranges) {
        this.variableId_d = varId;
        this.variableKind_d = varKind;
        this.variableMask_d = varMask;
        this.variableSize_d = varSize;
        this.variableFractionSize_d = varFractionSize;
        this.isDefault_d = false;
        this.isMeasure = isMeasure;
        this.isDimension = isDimension;
        this.isCounter = isCounter;
        this.isAttribute = isAttribute;
        this.hasRanges = hasRanges;
        this.ranges = ranges;
        this.setLabels(labels);
    }

    protected VarDefinition() {
    }

    @Exclude
    private VarDefinition(String varId, int varKind, String varMask, int varSize, int varFractionSize, boolean isMeasure, boolean isDimension, boolean isCounter, Msg labels, boolean hasRanges, List<Range> ranges) {
        this.variableId_d = varId;
        this.variableKind_d = varKind;
        this.variableMask_d = varMask;
        this.variableSize_d = varSize;
        this.variableFractionSize_d = varFractionSize;
        this.isDefault_d = false;
        this.isMeasure = isMeasure;
        this.isDimension = isDimension;
        this.isCounter = isCounter;
        this.hasRanges = hasRanges;
        this.ranges = ranges;
        this.labels = null;
        this.msgLabels = labels;
    }

    public static String getDatabaseColumnName(String varId) {
        String result = dbColumnMap.get(varId);
        return result != null ? result : VarUtils.getExternalVariableDatabaseColumnName(varId);
    }

    public static SortedMap<String, VarDefinition> getDefaultVarDefinition() {
        SortedStringMap<VarDefinition> result = SortedStringMap.createCaseInsensitive();
        VarDefinition.addAll(result, VarDefinition.createInstanceDefaults());
        VarDefinition.addAll(result, VarDefinition.createApplicationDefaults());
        VarDefinition.addAll(result, VarDefinition.createAttachmentDefaults());
        return result;
    }

    public static VarDefinition getDefaultVarDefinition(String variableId) {
        return (VarDefinition)VarDefinition.getDefaultVarDefinition().get(variableId);
    }

    public static boolean isExternal(String variableId) {
        String fixedVariable = VarUtils.getExternalVariableFromDatabaseColumnName(variableId);
        return VarDefinition.getDefaultVarDefinition().get(fixedVariable) == null;
    }

    public static VarDefinition[] createApplicationDefaults() {
        if (applicationDefaults_d == null) {
            VarDefinition[] applicationDefaults = new VarDefinition[]{VarDefinition.createDefault(TASK_ID, 5, 6, PapiMsg.VAR_TASK_KEY), VarDefinition.createDefault(DESCRIPTION_ID, 5, 50, PapiMsg.DESCRIPTION), VarDefinition.createDefault(PROCESS_ID, 5, 15, PapiMsg.PROCESS)};
            applicationDefaults_d = applicationDefaults;
        }
        return applicationDefaults_d;
    }

    public static VarDefinition[] createAttachmentDefaults() {
        if (attachmentDefaults_d == null) {
            VarDefinition[] attachmentDefaults = new VarDefinition[]{VarDefinition.createDefault(NAME_ID, 5, 15, CoreMsg.NAME), VarDefinition.createDefault(VERSION_ID, 2, 3, PapiMsg.VAR_VERSION_KEY), VarDefinition.createDefault(CREATOR_ID, 5, 10, PapiMsg.VAR_CREATOR_KEY), VarDefinition.createDefault(SIZE_ID, 2, 3, PapiMsg.VAR_SIZE_KEY), VarDefinition.createDefault(FILENAME_ID, 5, 15, PapiMsg.VAR_FILENAME_KEY), VarDefinition.createDefault(LOCKER_ID, 5, 10, PapiMsg.VAR_LOCKER_KEY)};
            attachmentDefaults_d = attachmentDefaults;
        }
        return attachmentDefaults_d;
    }

    public static VarDefinition[] createInstanceDefaults() {
        if (instanceDefaults_d == null) {
            VarDefinition[] instanceDefaults = new VarDefinition[]{VarDefinition.createDefault(PRIORITY_ID, 2, 1, PapiMsg.VAR_PRIORITY_KEY), VarDefinition.createDefault(HAS_ATTACHMENTS, 1, 1, PapiMsg.VAR_HAS_ATTACHMENTS_KEY), VarDefinition.createDefault(HAS_NOTES, 1, 1, PapiMsg.VAR_HAS_NOTES_KEY), VarDefinition.createDefault(DESCRIPTION_ID, 5, 50, PapiMsg.DESCRIPTION), VarDefinition.createDefault(PROCESS_ID, 5, 15, PapiMsg.PROCESS), VarDefinition.createDefault(ACTIVITY_ID, 5, 15, PapiMsg.ACTIVITY), VarDefinition.createDefault(STATUS_ID, 2, 7, PapiMsg.VAR_STATUS_KEY), VarDefinition.createDefault(RECEIVED_ID, 6, 12, PapiMsg.VAR_RECEIVED_KEY), VarDefinition.createDefault(DEADLINE_ID, 6, 12, PapiMsg.VAR_DEADLINE_KEY), VarDefinition.createDefault(PROCESS_DEADLINE_ID, 6, 12, PapiMsg.VAR_PROCESS_DEADLINE_KEY), VarDefinition.createDefault(ACTIVITY_DEADLINE_ID, 6, 12, PapiMsg.VAR_ACTIVITY_DEADLINE_KEY), VarDefinition.createDefault(PARTICIPANT_ID, 5, 10, PapiMsg.PARTICIPANT), VarDefinition.createDefault(COPY_ID, 2, 3, PapiMsg.COPY), VarDefinition.createDefault(AUTHOR_ID, 5, 10, PapiMsg.VAR_AUTHOR_KEY), VarDefinition.createDefault(CREATION_TIME_ID, 6, 15, PapiMsg.VAR_CREATION_TIME_KEY), VarDefinition.createDefault(PARENT_COPY_ID, 2, 5, PapiMsg.VAR_PARENT_COPY_KEY), VarDefinition.createDefault(INSTANCE_NUMBER, 2, 7, PapiMsg.VAR_INSTANCE_NUMBER_KEY), VarDefinition.createDefault(AUTHOR_DISPLAYNAME, 5, 25, PapiMsg.VAR_AUTHOR_DISPLAYNAME_KEY), VarDefinition.createDefault(MAIN_TASK_PARTICIPANT_ID, 5, 10, PapiMsg.VAR_MAIN_TASK_PARTICIPANT_ID)};
            instanceDefaults_d = instanceDefaults;
        }
        return instanceDefaults_d;
    }

    public void setFractionSize(int size) {
        this.variableFractionSize_d = size;
    }

    public int getFractionSize() {
        return this.variableFractionSize_d;
    }

    public String getId() {
        return this.variableId_d;
    }

    public String getProcessNameAndID() {
        return this.getId();
    }

    public int getKind() {
        return this.variableKind_d;
    }

    public String getLabel(Locale locale) {
        String label = null;
        if (this.labels != null && locale != null && (label = this.labels.getString(locale)).trim().isEmpty()) {
            boolean useCountry = locale.getCountry() != null && !locale.getCountry().isEmpty();
            String languageLabel = null;
            for (Map.Entry<Locale, String> entry : this.labels.entrySet()) {
                if (!locale.getLanguage().equalsIgnoreCase(entry.getKey().getLanguage())) continue;
                if (!useCountry || locale.getCountry().equalsIgnoreCase(entry.getKey().getCountry())) {
                    return entry.getValue();
                }
                languageLabel = entry.getValue();
            }
            if (label.trim().isEmpty()) {
                String string = label = languageLabel == null ? this.labels.getString() : languageLabel;
            }
        }
        if (label == null && this.msgLabels != null && locale != null && (label = this.msgLabels.getString(locale)) == null) {
            label = this.msgLabels.getString();
        }
        return label == null || label.trim().isEmpty() ? this.variableId_d : label;
    }

    public Map<String, String> getLabels() {
        TreeMap<String, String> labelsMap;
        block3: {
            block2: {
                labelsMap = new TreeMap<String, String>();
                if (this.labels == null) break block2;
                for (Map.Entry<Locale, String> entry : this.labels.entrySet()) {
                    labelsMap.put(entry.getKey().toString(), entry.getValue());
                }
                break block3;
            }
            if (this.msgLabels == null) break block3;
            for (Map.Entry<Locale, String> entry : this.msgLabels.getAllAvailableTranslationsForProjectLanguages()) {
                labelsMap.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return labelsMap;
    }

    public String getMask() {
        return this.variableMask_d;
    }

    public boolean isBusiness() {
        return this.isMeasure || this.isDimension;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public boolean isMeasure() {
        return this.isMeasure;
    }

    public boolean hasRanges() {
        return this.hasRanges;
    }

    public List<Range> getRanges() {
        ArrayList<Range> _ranges = new ArrayList<Range>();
        if (this.hasRanges() && this.ranges != null) {
            _ranges.addAll(this.ranges);
        }
        return _ranges;
    }

    public void setSize(int size) {
        this.variableSize_d = size;
    }

    public int getSize() {
        return this.variableSize_d;
    }

    public boolean isExternal() {
        return !this.isDefault();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof VarDefinition) {
            boolean checkMask;
            boolean checkId;
            VarDefinition var = (VarDefinition)obj;
            boolean bl = checkId = this.getId() != null && var.getId() != null;
            checkId = checkId ? this.getId().equalsIgnoreCase(var.getId()) : this.getId() == null && var.getId() == null;
            boolean bl2 = checkMask = this.getMask() != null && var.getMask() != null;
            checkMask = checkMask ? this.getMask().equals(var.getMask()) : this.getMask() == null && var.getMask() == null;
            return checkId && this.getKind() == var.getKind() && this.getSize() == var.getSize() && this.getFractionSize() == var.getFractionSize() && checkMask && this.isDefault() == var.isDefault();
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.variableId_d == null ? 0 : this.variableId_d.hashCode() % 10000;
        hashcode += this.variableMask_d == null ? 0 : this.variableMask_d.hashCode() % 1000 * 10000;
        hashcode += this.variableKind_d * 100000;
        hashcode += this.variableSize_d;
        hashcode += this.variableFractionSize_d;
        return hashcode += this.isDefault_d ? 1 : 0;
    }

    public String toString() {
        return "VarDefinition[id:" + this.getId() + ", kind:" + this.getKind() + ", size: " + this.getSize() + ", mask: " + this.getMask() + "]";
    }

    public boolean isDefault() {
        return this.isDefault_d;
    }

    private static void addAll(SortedStringMap<VarDefinition> defaultVarDefinitions, VarDefinition[] varDefinitions) {
        for (VarDefinition var : varDefinitions) {
            defaultVarDefinitions.put(var.getId(), var);
        }
    }

    private static VarDefinition createDefault(String variableId, int kind, int size, Msg msg) {
        VarDefinition defaultVar = new VarDefinition(variableId, kind, NO_MASK, size, 0, false, false, false, msg, false, null);
        defaultVar.setAsDefault();
        return defaultVar;
    }

    private void setAsDefault() {
        this.isDefault_d = true;
    }

    private void setLabels(LocaleStringMap labels) {
        LocaleStringMap newLabels = LocaleStringMap.create();
        if (labels != null) {
            newLabels.putAll(labels);
        }
        this.labels = newLabels;
    }

    static {
        dbColumnMap.put(ACTIVITY_DEADLINE_ID, ACTIVITY_DEADLINE_DB);
        dbColumnMap.put(ACTIVITY_ID, ACTIVITY_DB);
        dbColumnMap.put(COPY_ID, COPY_DB);
        dbColumnMap.put(CREATOR_ID, CREATOR_DB);
        dbColumnMap.put(DEADLINE_ID, "");
        dbColumnMap.put(DESCRIPTION_ID, DESCRIPTION_DB);
        dbColumnMap.put(FILENAME_ID, FILENAME_DB);
        dbColumnMap.put(LOCKER_ID, LOCKER_DB);
        dbColumnMap.put(NAME_ID, NAME_DB);
        dbColumnMap.put(PARTICIPANT_ID, PARTICIPANT_DB);
        dbColumnMap.put(PRIORITY_ID, PRIORITY_DB);
        dbColumnMap.put(PROCESS_DEADLINE_ID, PROCESS_DEADLINE_DB);
        dbColumnMap.put(PROCESS_ID, PROCESS_DB);
        dbColumnMap.put(RECEIVED_ID, RECEIVED_DB);
        dbColumnMap.put(SIZE_ID, SIZE_DB);
        dbColumnMap.put(STATUS_ID, STATUS_DB);
        dbColumnMap.put(TASK_ID, TASK_DB);
        dbColumnMap.put(VERSION_ID, VERSION_DB);
        dbColumnMap.put(AUTHOR_ID, AUTHOR_DB);
        dbColumnMap.put(CREATION_TIME_ID, CREATION_TIME_DB);
        dbColumnMap.put(HAS_NOTES, "");
        dbColumnMap.put(HAS_ATTACHMENTS, "");
        dbColumnMap.put(PARENT_COPY_ID, PARENT_COPY_DB);
        dbColumnMap.put(INSTANCE_NUMBER, INSTANCE_NUMBER_DB);
        dbColumnMap.put(MAIN_TASK_PARTICIPANT_ID, "");
        dbColumnMap.put(AUTHOR_DISPLAYNAME, "");
    }

    public static class Range
    implements Serializable {
        private BigDecimal finish = new BigDecimal(0);
        private String name = null;
        private BigDecimal start = new BigDecimal(0);
        @Exclude
        static final long serialVersionUID = 20100426143800L;

        @Exclude
        public Range(String name, BigDecimal start, BigDecimal finish) {
            this.name = name;
            this.start = start;
            this.finish = finish;
        }

        public String getName() {
            return this.name;
        }

        public BigDecimal getStart() {
            return this.start;
        }

        public BigDecimal getFinish() {
            return this.finish;
        }

        public String toString() {
            return this.name.concat(" (").concat(this.start.toString()).concat(" - ").concat(this.finish.toString()).concat(")");
        }
    }
}

