/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Papi")
public enum StatusScope implements I18nProvider
{
    ONLY_INPROCESS(PapiMsg.ONLY_INPROCESS),
    ONLY_COMPLETED(PapiMsg.ONLY_COMPLETED),
    ONLY_ABORTED(PapiMsg.ONLY_ABORTED),
    ONLY_ERRORED(PapiMsg.ONLY_ERRORED),
    ONLY_PENDING_MIGRATION(PapiMsg.ONLY_PENDING_MIGRATION),
    INPROCESS_AND_COMPLETED(PapiMsg.INPROCESS_AND_COMPLETED),
    INPROCESS_AND_ABORTED(PapiMsg.INPROCESS_AND_ABORTED),
    ABORTED_AND_COMPLETED(PapiMsg.ABORTED_AND_COMPLETED),
    ONLY_SUSPENDED(PapiMsg.ONLY_SUSPENDED),
    ALL(PapiMsg.ALL),
    OPEN(PapiMsg.OPEN);

    private transient Msg msg;

    private StatusScope(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }

    public boolean isInProcess() {
        return this == ALL || this == OPEN || this == INPROCESS_AND_COMPLETED || this == INPROCESS_AND_ABORTED || this == ONLY_INPROCESS;
    }

    public boolean isCompleted() {
        return this == ALL || this == INPROCESS_AND_COMPLETED || this == ABORTED_AND_COMPLETED || this == ONLY_COMPLETED;
    }

    public boolean isAborted() {
        return this == ALL || this == INPROCESS_AND_ABORTED || this == ABORTED_AND_COMPLETED || this == ONLY_ABORTED;
    }

    public boolean isErrored() {
        return this == ALL || this == OPEN || this == ONLY_ERRORED;
    }

    public boolean isPendingMigration() {
        return this == ALL || this == OPEN || this == ONLY_PENDING_MIGRATION;
    }

    public boolean isSuspended() {
        return this == ALL || this == OPEN || this == ONLY_SUSPENDED;
    }

    public static StatusScope valueOf(boolean inProcess, boolean completed, boolean aborted) {
        return StatusScope.valueOf(inProcess, completed, aborted, false, false);
    }

    public static StatusScope valueOf(boolean inProcess, boolean completed, boolean aborted, boolean errored, boolean isPendingMigration) {
        StatusScope result;
        if (inProcess && completed && aborted && errored) {
            result = ALL;
        } else {
            if (!(inProcess || completed || aborted)) {
                if (errored) {
                    return ONLY_ERRORED;
                }
                if (isPendingMigration) {
                    return ONLY_PENDING_MIGRATION;
                }
                throw new IllegalArgumentException("Status is not selected");
            }
            if (inProcess) {
                result = completed ? (aborted ? ALL : INPROCESS_AND_COMPLETED) : (aborted ? INPROCESS_AND_ABORTED : ONLY_INPROCESS);
            } else if (completed) {
                result = aborted ? ABORTED_AND_COMPLETED : ONLY_COMPLETED;
            } else {
                if (!aborted) {
                    throw new IllegalArgumentException("Illegal combination");
                }
                result = ONLY_ABORTED;
            }
        }
        return result;
    }

    public static StatusScope getInProcess() {
        return ONLY_INPROCESS;
    }

    public static StatusScope getInAborted() {
        return ONLY_ABORTED;
    }

    public static StatusScope getInCompleted() {
        return ONLY_COMPLETED;
    }

    public static StatusScope getInErrored() {
        return ONLY_ERRORED;
    }

    public static StatusScope getInPendingMigration() {
        return ONLY_PENDING_MIGRATION;
    }

    public static StatusScope getInSuspended() {
        return ONLY_SUSPENDED;
    }

    public static StatusScope getInAll() {
        return ALL;
    }

    public static StatusScope getInOpen() {
        return OPEN;
    }
}

