/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Papi")
public enum Comparison implements I18nProvider
{
    IS(PapiMsg.IS, "="),
    IS_NOT(PapiMsg.IS_NOT, "<>"),
    LESS_THAN(PapiMsg.LESS_THAN, "<"),
    LESS_OR_EQUALS(PapiMsg.LESS_OR_EQUALS, "<="),
    GREATER_THAN(PapiMsg.GREATER_THAN, ">"),
    GREATER_OR_EQUALS(PapiMsg.GREATER_OR_EQUALS, ">="),
    IS_NULL(PapiMsg.IS_NULL, "IS NULL"),
    IS_NOT_NULL(PapiMsg.IS_NOT_NULL, "IS NOT NULL"),
    BEGIN_WITH(PapiMsg.BEGIN_WITH, "LIKE", true),
    NOT_BEGIN_WITH(PapiMsg.NOT_BEGIN_WITH, "NOT LIKE", true),
    END_WITH(PapiMsg.END_WITH, "LIKE", true),
    NOT_END_WITH(PapiMsg.NOT_END_WITH, "NOT LIKE", true),
    CONTAINS(PapiMsg.CONTAINS, "LIKE", true),
    NOT_CONTAINS(PapiMsg.NOT_CONTAINS, "NOT LIKE", true),
    BEFORE(PapiMsg.BEFORE, "<"),
    AFTER(PapiMsg.AFTER, ">"),
    BETWEEN(PapiMsg.BETWEEN, "BETWEEN"),
    NOT_BETWEEN(PapiMsg.NOT_BETWEEN, "NOT BETWEEN");

    private transient Msg msg;
    private transient String expr;
    private transient String booleanExpr;
    private transient boolean isTestComparisonOnly;

    private Comparison(Msg msg, String expr) {
        this.msg = msg;
        this.expr = " " + expr + " ";
    }

    private Comparison(Msg msg, String expr, boolean isTextComparisonOnly) {
        this(msg, expr);
        this.isTestComparisonOnly = isTextComparisonOnly;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }

    public boolean isTextComparisonOnly() {
        return this.isTestComparisonOnly;
    }

    public boolean isTimeComparisonOnly() {
        return this == BEFORE || this == AFTER || this == BETWEEN;
    }

    public String getSQLExpression() {
        return this.expr;
    }

    public static List<Comparison> getNumericalComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(LESS_THAN);
        operators.add(LESS_OR_EQUALS);
        operators.add(GREATER_THAN);
        operators.add(GREATER_OR_EQUALS);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        operators.add(BETWEEN);
        operators.add(NOT_BETWEEN);
        return operators;
    }

    public static List<Comparison> getAlfanumericComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(CONTAINS);
        operators.add(NOT_CONTAINS);
        operators.add(BEGIN_WITH);
        operators.add(NOT_BEGIN_WITH);
        operators.add(END_WITH);
        operators.add(NOT_END_WITH);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        return operators;
    }

    public static List<Comparison> getBooleanComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        return operators;
    }

    public static List<Comparison> getTimeComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(BEFORE);
        operators.add(AFTER);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        operators.add(BETWEEN);
        operators.add(NOT_BETWEEN);
        return operators;
    }
}

