/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ColumnFormatType implements I18nProvider
{
    DATE_FULL(PapiMsg.DATE_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_LONG(PapiMsg.DATE_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_MEDIUM(PapiMsg.DATE_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_SHORT(PapiMsg.DATE_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_FULL(PapiMsg.DATE_TIME_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(0, 0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_LONG(PapiMsg.DATE_TIME_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(1, 1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_MEDIUM(PapiMsg.DATE_TIME_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(2, 2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_SHORT(PapiMsg.DATE_TIME_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(3, 3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_CUSTOM(PapiMsg.DATE_CUSTOM){

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(2, 2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_FULL(PapiMsg.TIME_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_LONG(PapiMsg.TIME_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_MEDIUM(PapiMsg.TIME_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_SHORT(PapiMsg.TIME_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    NUMBER_INTEGER(PapiMsg.NUMBER_INTEGER){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getIntegerInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_DECIMAL(PapiMsg.NUMBER_DECIMAL){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_CURRENCY(PapiMsg.NUMBER_CURRENCY){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getCurrencyInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_PERCENT(PapiMsg.NUMBER_PERCENT){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getPercentInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_CUSTOM(PapiMsg.NUMBER_CUSTOM){

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    };

    private transient Msg msg;

    private ColumnFormatType(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Format getFormat(Locale locale) {
        return null;
    }

    public Format getFormat(Locale locale, String pattern) {
        return null;
    }

    public boolean isCustom() {
        return false;
    }

    Object getPreviewObject() {
        return null;
    }

    public String getFormatPreview(Locale locale) {
        return this.getFormat(locale).format(this.getPreviewObject());
    }

    public String getFormatPreview(Locale locale, String pattern) {
        return this.getFormat(locale, pattern).format(this.getPreviewObject());
    }

    public static List<ColumnFormatType> getTimeFormatTypes() {
        ArrayList<ColumnFormatType> types = new ArrayList<ColumnFormatType>();
        types.add(DATE_FULL);
        types.add(DATE_LONG);
        types.add(DATE_MEDIUM);
        types.add(DATE_SHORT);
        types.add(TIME_FULL);
        types.add(TIME_LONG);
        types.add(TIME_MEDIUM);
        types.add(TIME_SHORT);
        types.add(DATE_TIME_FULL);
        types.add(DATE_TIME_LONG);
        types.add(DATE_TIME_MEDIUM);
        types.add(DATE_TIME_SHORT);
        types.add(DATE_CUSTOM);
        return types;
    }

    public static List<ColumnFormatType> getNumericalFormatTypes() {
        ArrayList<ColumnFormatType> types = new ArrayList<ColumnFormatType>();
        types.add(NUMBER_INTEGER);
        types.add(NUMBER_DECIMAL);
        types.add(NUMBER_CURRENCY);
        types.add(NUMBER_PERCENT);
        types.add(NUMBER_CUSTOM);
        return types;
    }
}

