/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.service.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.bpm.bac.core.BacConfig;
import oracle.bpm.bac.core.BacConnection;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.impl.svn.SvnConnection;
import oracle.bpm.bac.core.io.Transaction;
import oracle.bpm.bac.core.model.BranchType;
import oracle.bpm.bac.core.model.Node;
import oracle.bpm.bac.core.model.Project;
import oracle.bpm.bac.service.PublishService;
import oracle.bpm.bac.service.impl.PublishServiceImpl;
import org.jetbrains.annotations.NotNull;

public class PublishServiceTxWrapperImpl
implements PublishService {
    private PublishService proxyService;
    private PublishService rawService;
    private static final Class<?> PROXY_CLASS = Proxy.getProxyClass(PublishService.class.getClassLoader(), PublishService.class);

    public PublishServiceTxWrapperImpl(@NotNull BacConfig config) throws BacException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.<init> must not be null");
        }
        this.proxyService = null;
        this.rawService = null;
        SvnConnection connection = SvnConnection.create(config);
        this.rawService = new PublishServiceImpl(connection);
        try {
            Constructor<?> constructor = PROXY_CLASS.getConstructor(InvocationHandler.class);
            this.proxyService = (PublishService)constructor.newInstance(new TxInvocationHandler(this.rawService, connection));
        }
        catch (NoSuchMethodException e) {
            throw BacException.createInitError(e);
        }
        catch (InvocationTargetException e) {
            throw BacException.createInitError(e);
        }
        catch (InstantiationException e) {
            throw BacException.createInitError(e);
        }
        catch (IllegalAccessException e) {
            throw BacException.createInitError(e);
        }
    }

    @Override
    public void createFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createFolder must not be null");
        }
        this.proxyService.createFolder(location);
    }

    @Override
    public void removeFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.removeFolder must not be null");
        }
        this.proxyService.removeFolder(location);
    }

    @Override
    public Project createProject(@NotNull String location, @NotNull String name) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createProject must not be null");
        }
        return this.proxyService.createProject(location, name);
    }

    @Override
    public void removeProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.removeProject must not be null");
        }
        this.proxyService.removeProject(project);
    }

    @Override
    public void createBranch(@NotNull Project baseOnProject, @NotNull BranchType type, @NotNull String name) throws BacException {
        if (baseOnProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createBranch must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.createBranch must not be null");
        }
        this.proxyService.createBranch(baseOnProject, type, name);
    }

    @Override
    public void mergeBranchToMain(@NotNull Project baseOnProject, @NotNull BranchType type, @NotNull String branchNameToMerge) throws BacException {
        if (baseOnProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.mergeBranchToMain must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.mergeBranchToMain must not be null");
        }
        if (branchNameToMerge == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.mergeBranchToMain must not be null");
        }
        this.proxyService.mergeBranchToMain(baseOnProject, type, branchNameToMerge);
    }

    @Override
    public void removeBranch(@NotNull Project project, @NotNull BranchType type, @NotNull String branchName) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.removeBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.removeBranch must not be null");
        }
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.removeBranch must not be null");
        }
        this.proxyService.removeBranch(project, type, branchName);
    }

    @Override
    public Project editProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.editProject must not be null");
        }
        return this.proxyService.editProject(project);
    }

    @Override
    public Project loadProject(@NotNull String fullProjectLocation) throws BacException {
        if (fullProjectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.loadProject must not be null");
        }
        return this.rawService.loadProject(fullProjectLocation);
    }

    @Override
    public boolean existsFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.existsFolder must not be null");
        }
        return this.rawService.existsFolder(location);
    }

    @Override
    public boolean existsProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl.existsProject must not be null");
        }
        return this.rawService.existsProject(project);
    }

    @Override
    public Node getRoot() throws BacException {
        return this.rawService.getRoot();
    }

    private final class TxInvocationHandler
    implements InvocationHandler {
        private BacConnection connection;
        private PublishService service;

        public TxInvocationHandler(@NotNull PublishService service, BacConnection connection) {
            if (PublishServiceTxWrapperImpl.this == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl$TxInvocationHandler.<init> must not be null");
            }
            if (service == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceTxWrapperImpl$TxInvocationHandler.<init> must not be null");
            }
            this.service = service;
            this.connection = connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                Transaction tx = this.connection.getTransaction();
                try {
                    tx.setAutoCommit(false);
                    tx.begin();
                    result = method.invoke((Object)this.service, args);
                    tx.commit();
                }
                catch (Throwable e) {
                    tx.rollback();
                    throw e;
                }
                finally {
                    this.connection.release(tx);
                }
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            return result;
        }
    }
}

