/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.service.impl;

import oracle.bpm.bac.core.BacConnection;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.io.Persistence;
import oracle.bpm.bac.core.model.BranchType;
import oracle.bpm.bac.core.model.Folder;
import oracle.bpm.bac.core.model.Project;
import oracle.bpm.bac.core.msg.BacMsg;
import oracle.bpm.bac.service.PublishService;
import org.jetbrains.annotations.NotNull;

public class PublishServiceImpl
implements PublishService {
    private BacConnection connection;

    public PublishServiceImpl(@NotNull BacConnection connection) throws BacException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.<init> must not be null");
        }
        this.connection = connection;
    }

    @Override
    public void createFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createFolder must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        persistence.createFolder(location);
    }

    @Override
    public void removeFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.removeFolder must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        persistence.deleteFolder(location);
    }

    @Override
    public boolean existsFolder(@NotNull String location) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.existsFolder must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        return persistence.existsFolder(location);
    }

    @Override
    public Project createProject(@NotNull String location, @NotNull String name) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createProject must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        return persistence.createProject(location, name);
    }

    @Override
    public void removeProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.removeProject must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        if (!this.existsProject(project)) {
            throw new BacException(BacMsg.PROJECT_NOT_EXISTS(project.getName(), project.getSvnPath()));
        }
        persistence.deleteProject(project);
    }

    @Override
    public boolean existsProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.existsProject must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        return persistence.existsProject(project.getSvnUrl());
    }

    @Override
    public void createBranch(@NotNull Project project, @NotNull BranchType type, @NotNull String branchName) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createBranch must not be null");
        }
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.createBranch must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        if (type == BranchType.SESSION || type == BranchType.MAIN) {
            throw BacException.createInvalidBranchType(type);
        }
        String svnPath = project.getSvnPath();
        persistence.createBranch(svnPath, type, branchName);
    }

    @Override
    public void mergeBranchToMain(@NotNull Project baseOnProject, @NotNull BranchType type, @NotNull String branchNameToMerge) throws BacException {
        if (baseOnProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.mergeBranchToMain must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.mergeBranchToMain must not be null");
        }
        if (branchNameToMerge == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.mergeBranchToMain must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeBranch(@NotNull Project project, @NotNull BranchType type, @NotNull String branchName) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.removeBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.removeBranch must not be null");
        }
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.removeBranch must not be null");
        }
        if (type == BranchType.MAIN) {
            throw new BacException(BacMsg.MAIN_CANT_REMOVED);
        }
        Persistence persistence = this.connection.createBacPersistence();
        persistence.deleteBranch(project, type, branchName);
    }

    @Override
    public Project loadProject(@NotNull String fullProjectLocation) throws BacException {
        if (fullProjectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.loadProject must not be null");
        }
        Persistence persistence = this.connection.createBacPersistence();
        if (!persistence.existsFolder(fullProjectLocation)) {
            throw new BacException(BacMsg.FOLDER_NOT_EXISTS(fullProjectLocation));
        }
        return persistence.loadProject(fullProjectLocation);
    }

    @Override
    public Project editProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/PublishServiceImpl.editProject must not be null");
        }
        if (!this.existsProject(project)) {
            throw new BacException(BacMsg.PROJECT_NOT_EXISTS(project.getName(), project.getSvnPath()));
        }
        Persistence persistence = this.connection.createBacPersistence();
        String svnPath = project.getSvnPath();
        persistence.aquireLock(svnPath);
        persistence.createBranch(svnPath, BranchType.SESSION, "currentUserId");
        return this.loadProject(svnPath);
    }

    @Override
    public Folder getRoot() throws BacException {
        Persistence persistence = this.connection.createBacPersistence();
        return persistence.getRoot();
    }
}

