/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.service.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.bac.core.BacConfig;
import oracle.bpm.bac.core.BacConnectionType;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.service.ManagementService;
import oracle.bpm.bac.service.artifact.jaxb.BacConfigurations;
import oracle.bpm.bac.service.artifact.jaxb.Configuration;
import oracle.bpm.bac.service.artifact.jaxb.ConnectionType;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

public final class ManagementServiceImpl
implements ManagementService {
    private VFileSystem configVFS;
    private static final String BAC_CONFIGURATIONS_XML = "bac_configurations.xml";
    private static final JAXBContext JAXB_CONTEXT;

    public ManagementServiceImpl(@NotNull MDSInstance mdsInstance) {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.<init> must not be null");
        }
        this.configVFS = null;
        this.configVFS = new MdsFileSystem(mdsInstance, "/bac/config");
    }

    @Override
    public List<BacConfig> getConfigurations() throws BacException {
        BacConfigurations bacConfiguration = this.getBacConfiguration();
        List<Configuration> configurationList = bacConfiguration.getConfiguration();
        ArrayList<BacConfig> configs = new ArrayList<BacConfig>();
        for (Configuration configuration : configurationList) {
            BacConfig bacConfig = this.createBacConfigFrom(configuration);
            configs.add(bacConfig);
        }
        return configs;
    }

    @Override
    public void addConfiguration(@NotNull BacConfig config) throws BacException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.addConfiguration must not be null");
        }
        BacConfigurations bacConfiguration = this.getBacConfiguration();
        List<Configuration> configurationList = bacConfiguration.getConfiguration();
        boolean exists = false;
        for (Configuration configuration : configurationList) {
            if (!configuration.getName().equals(config.getName())) continue;
            exists = true;
            break;
        }
        if (exists) {
            throw BacException.createConfigNameAlreadyExists(config.getName());
        }
        Configuration configuration = new Configuration();
        configuration.setName(config.getName());
        configuration.setDescription(config.getDescription());
        configuration.setConnectionString(config.getConnectionString());
        ConnectionType conType = config.getConnectionType() == BacConnectionType.LOCAL ? ConnectionType.LOCAL : ConnectionType.REMOTE;
        configuration.setType(conType);
        configurationList.add(configuration);
        this.serialize(bacConfiguration);
    }

    @Override
    public void removeConfiguration(@NotNull String configName) throws BacException {
        if (configName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.removeConfiguration must not be null");
        }
        BacConfigurations bacConfiguration = this.getBacConfiguration();
        List<Configuration> configurationList = bacConfiguration.getConfiguration();
        ArrayList<Configuration> newConfigList = new ArrayList<Configuration>(configurationList);
        boolean removed = false;
        for (Configuration configuration : newConfigList) {
            if (!configuration.getName().equals(configName)) continue;
            configurationList.remove(configuration);
            removed = true;
            break;
        }
        if (!removed) {
            throw BacException.createConfigNameNotExists(configName);
        }
        this.serialize(bacConfiguration);
    }

    @Override
    public BacConfig getConfiguration(@NotNull String name) throws BacException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.getConfiguration must not be null");
        }
        BacConfigurations bacConfiguration = this.getBacConfiguration();
        List<Configuration> configurationList = bacConfiguration.getConfiguration();
        BacConfig bacConfig = null;
        for (Configuration configuration : configurationList) {
            if (!configuration.getName().equals(name)) continue;
            bacConfig = this.createBacConfigFrom(configuration);
            break;
        }
        return bacConfig;
    }

    private BacConfig createBacConfigFrom(Configuration configuration) {
        ConnectionType type = configuration.getType();
        BacConnectionType connType = type == ConnectionType.LOCAL ? BacConnectionType.LOCAL : BacConnectionType.REMOTE;
        return BacConfig.create(configuration.getName(), configuration.getConnectionString(), configuration.getDescription(), connType);
    }

    private BacConfigurations getBacConfiguration() throws BacException {
        BacConfigurations bacConfigurations;
        VFile file = this.configVFS.createFile(BAC_CONFIGURATIONS_XML);
        VFileInputStream stream = null;
        try {
            stream = new VFileInputStream(file);
            bacConfigurations = this.deserialize((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw BacException.createIOReadingBacConfiguration(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{stream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{stream});
        return bacConfigurations;
    }

    private void serialize(@NotNull BacConfigurations raw) throws BacException {
        if (raw == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.serialize must not be null");
        }
        try {
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            VFile file = this.configVFS.createFile(BAC_CONFIGURATIONS_XML);
            marshaller.marshal((Object)raw, (OutputStream)new VFileOutputStream(file));
        }
        catch (JAXBException e) {
            throw BacException.createIOReadingBacConfiguration(e);
        }
        catch (IOException e) {
            throw BacException.createIOReadingBacConfiguration(e);
        }
    }

    private BacConfigurations deserialize(@NotNull InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/service/impl/ManagementServiceImpl.deserialize must not be null");
        }
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            JAXBElement o = unmarshaller.unmarshal((Source)new StreamSource(input), BacConfigurations.class);
            return (BacConfigurations)o.getValue();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{BacConfigurations.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

