/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.WorkflowServiceLocator;
import oracle.bpel.services.workflow.metadata.ITaskMetadataService;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.task.model.Assignee;
import oracle.bpm.casemgmt.task.model.Task;
import oracle.bpm.casemgmt.task.model.TaskInfo;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class TaskQueryUtil {
    public static List<oracle.bpel.services.workflow.task.model.Task> queryTasks(IBPMContext context, String rootTaskId) throws BPMException, WorkflowException {
        ITaskQueryService taskQueryService = WorkflowServiceLocator.getTaskQueryService();
        Predicate predicate = new Predicate(Column.getColumn((String)"rootTaskId"), Predicate.getOperationNumber((String)"EQ"), (Object)rootTaskId);
        ArrayList<String> displayColumns = new ArrayList<String>();
        displayColumns.add("assignees");
        List tasks = taskQueryService.queryTasks((IWorkflowContext)context, displayColumns, null, ITaskQueryService.AssignmentFilter.ALL, null, predicate, null, 0, 0);
        return tasks;
    }

    public static boolean hasViewPermission(oracle.bpel.services.workflow.task.model.Task task) {
        boolean hasViewTaskPermission = false;
        List systemActions = task.getSystemAttributes().getSystemActions();
        for (int systemActionsIdx = 0; systemActionsIdx < systemActions.size(); ++systemActionsIdx) {
            ActionType actionType = (ActionType)systemActions.get(systemActionsIdx);
            if (actionType == null || !"VIEW_TASK".equals(actionType.getAction())) continue;
            hasViewTaskPermission = true;
            break;
        }
        return hasViewTaskPermission;
    }

    public static TaskInfo getTaskAssignees(IBPMContext context, String rootTaskId, String activityType) {
        String methodName = "getTaskAssignee";
        TaskInfo taskInfo = null;
        if (activityType != null && activityType.equals("HWF") && rootTaskId != null) {
            List<oracle.bpel.services.workflow.task.model.Task> tasks = null;
            try {
                tasks = TaskQueryUtil.queryTasks(context, rootTaskId);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tasks != null && tasks.size() > 0) {
                taskInfo = new TaskInfo();
                for (oracle.bpel.services.workflow.task.model.Task task : tasks) {
                    Task caseTask = new Task();
                    if (task.getSystemAttributes().getTaskId().equals(rootTaskId)) {
                        caseTask.setIsRoot(true);
                    } else {
                        caseTask.setIsRoot(false);
                    }
                    if (TaskQueryUtil.hasViewPermission(task)) {
                        caseTask.setHasViewPermission(true);
                    } else {
                        caseTask.setHasViewPermission(false);
                    }
                    caseTask.setTaskId(task.getSystemAttributes().getTaskId());
                    caseTask.setOutcome(task.getSystemAttributes().getOutcome());
                    caseTask.setOutcomeDisplayName(TaskQueryUtil.getOutcomeDisplayName(context, task, task.getSystemAttributes().getOutcome()));
                    List assignees = task.getSystemAttributes().getAssignees();
                    CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, methodName + ": rootTaskId: " + rootTaskId + ", taskId: " + caseTask.getTaskId() + ", isRootTask: " + caseTask.getIsRoot() + ", hasViewPermission: " + caseTask.getHasViewPermission() + ", tasks size: " + tasks.size() + ", assignees size: " + assignees.size());
                    for (IdentityType identity : assignees) {
                        Assignee taskAssignee = new Assignee();
                        taskAssignee.setValue(identity.getId());
                        taskAssignee.setType(identity.getType());
                        if (identity.getDisplayName() == null || identity.getDisplayName().isEmpty()) {
                            taskAssignee.setDisplayName(identity.getId());
                        } else {
                            taskAssignee.setDisplayName(identity.getDisplayName());
                        }
                        caseTask.getAssignees().add(taskAssignee);
                        CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, methodName + ": added assignee: id " + identity.getId() + ", type: " + identity.getType());
                    }
                    taskInfo.getTasks().add(caseTask);
                }
            }
        }
        return taskInfo;
    }

    private static String getOutcomeDisplayName(IBPMContext context, oracle.bpel.services.workflow.task.model.Task task, String outcome) {
        try {
            ITaskMetadataService taskMetadataService = WorkflowServiceLocator.getTaskMetadataService();
            Map outcomes = taskMetadataService.getOutcomes((IWorkflowContext)context, task, context.getLocale());
            String outcomeDisplayName = (String)outcomes.get(outcome);
            if (outcomeDisplayName == null || outcomeDisplayName.isEmpty()) {
                outcomeDisplayName = outcome;
            }
            return outcomeDisplayName;
        }
        catch (Exception e) {
            return outcome;
        }
    }
}

