/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.w3c.dom.Node;

public class MOXyUtil {
    private JAXBContext jaxbContext = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;

    public MOXyUtil() {
    }

    public MOXyUtil(String eclipselinkOxm, String pkgName, Class myClass) {
        try {
            HashMap<String, StreamSource> metadataSourceMap = new HashMap<String, StreamSource>();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(eclipselinkOxm);
            metadataSourceMap.put(pkgName, new StreamSource(is));
            HashMap<String, HashMap<String, StreamSource>> properties = new HashMap<String, HashMap<String, StreamSource>>();
            properties.put("eclipselink-oxm-xml", metadataSourceMap);
            Class[] classes = new Class[]{myClass};
            this.jaxbContext = JAXBContext.newInstance((Class[])classes, properties);
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
            this.marshaller = this.jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException jaxbe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "MOXyUtil", jaxbe);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void marshal(Object obj, String xmlFile) {
        try {
            FileOutputStream fis = new FileOutputStream(xmlFile);
            CaseLogger.log(LoggerComponent.COMPONENT_CM_ACTIVITY, Severity.DEBUG, "Marshalling to " + xmlFile);
            this.marshaller.marshal(obj, (OutputStream)fis);
        }
        catch (JAXBException jaxbe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "marshal", jaxbe);
        }
        catch (FileNotFoundException fnfe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "marshal", fnfe);
        }
    }

    public Object unmarshall(String xmlFile, Class myClass) {
        JAXBElement jaxbElement = null;
        Object jaxbElementValue = null;
        try {
            File file = new File(xmlFile);
            StreamSource source = new StreamSource(file);
            CaseLogger.log(LoggerComponent.COMPONENT_CM_ACTIVITY, Severity.DEBUG, "Unmarshalling from " + xmlFile);
            jaxbElement = this.unmarshaller.unmarshal((Source)source, myClass);
            jaxbElementValue = jaxbElement.getValue();
        }
        catch (JAXBException jaxbe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "unmarshall", jaxbe);
        }
        return jaxbElementValue;
    }

    public void marshal(Object obj, Node node) {
        try {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_ACTIVITY, Severity.DEBUG, "Marshalling to node" + node);
            this.marshaller.marshal(obj, node);
        }
        catch (JAXBException jaxbe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "marshal", jaxbe);
        }
    }

    public Object unmarshall(Node node, Class myClass) {
        JAXBElement jaxbElement = null;
        Object jaxbElementValue = null;
        try {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_ACTIVITY, Severity.DEBUG, "Unmarshalling from Node " + node);
            jaxbElement = this.unmarshaller.unmarshal(node, myClass);
            jaxbElementValue = jaxbElement.getValue();
        }
        catch (JAXBException jaxbe) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, this.getClass().getName(), "unmarshall", jaxbe);
        }
        return jaxbElementValue;
    }

    public String marshal(Object obj) {
        String xml = null;
        try {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_ACTIVITY, Severity.DEBUG, "Marshalling to String");
            StringWriter writer = new StringWriter();
            this.marshaller.marshal(obj, (Writer)writer);
            xml = writer.toString();
        }
        catch (JAXBException jaxbe) {
            jaxbe.printStackTrace();
        }
        return xml;
    }
}

