/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.Comment;

@DiscriminatorValue(value="STAKEHOLDER")
@Entity
@NamedQueries(value={@NamedQuery(name="CaseStakeHolder.findAll", query="select caseStakeHolder from CaseStakeHolder caseStakeHolder LEFT JOIN FETCH caseStakeHolder.comment"), @NamedQuery(name="CaseStakeHolder.findByCaseId", query="select caseStakeHolder from CaseStakeHolder caseStakeHolder LEFT JOIN FETCH caseStakeHolder.comment where caseStakeHolder.case_id = :case_id order by caseStakeHolder.object_name ASC")})
@Table(name="CM_CASE_STAKE_HOLDER")
public class CaseStakeHolder
extends CaseObject
implements Serializable {
    @OneToMany(targetEntity=CaseStakeHolderMember.class, mappedBy="caseStakeHolder", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderBy(value=" stakeHolder ASC")
    protected List<CaseStakeHolderMember> caseStakeHolderMembers;
    @Column(name="APPLICATION_CONTEXT", nullable=true, unique=false, length=400)
    private String applicationContext;
    @JoinColumn(name="COMMENT_ID", insertable=true, updatable=true, nullable=true)
    @OneToOne(targetEntity=Comment.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Comment comment;
    @Transient
    private boolean isContextUserInRole = false;
    @Column(name="PERMISSION_MEMBER_ROLE", length=400)
    private String permissionMemberRole;

    public void setApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContext() {
        return this.applicationContext;
    }

    public void setPermissionMemberRole(String permissionMemberRole) {
        this.permissionMemberRole = permissionMemberRole;
    }

    public String getPermissionMemberRole() {
        return this.permissionMemberRole;
    }

    public void setCaseStakeHolderMembers(List<CaseStakeHolderMember> caseStakeHolderMembers) {
        this.caseStakeHolderMembers = caseStakeHolderMembers;
    }

    public List<CaseStakeHolderMember> getCaseStakeHolderMembers() {
        return this.caseStakeHolderMembers;
    }

    public void addCaseStakeHolderMember(CaseStakeHolderMember caseStakeHolderMember) {
        if (caseStakeHolderMember != null) {
            if (this.caseStakeHolderMembers == null) {
                this.caseStakeHolderMembers = new ArrayList<CaseStakeHolderMember>();
            }
            this.caseStakeHolderMembers.add(caseStakeHolderMember);
        }
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setIsContextUserInRole(boolean isContextUserInRole) {
        this.isContextUserInRole = isContextUserInRole;
    }

    public boolean getIsContextUserInRole() {
        return this.isContextUserInRole;
    }

    @Override
    public String toString(String prefix) {
        String caseStakeholderPrefix = prefix == null ? "\n" : "\n" + prefix;
        StringBuffer caseStakeHolderAsAString = new StringBuffer(caseStakeholderPrefix + "CaseStakeHolder");
        caseStakeHolderAsAString.append(super.toString(prefix));
        caseStakeHolderAsAString.append(caseStakeholderPrefix + "\tisContextUserInRole:" + this.getIsContextUserInRole());
        if (this.caseStakeHolderMembers != null) {
            for (CaseStakeHolderMember caseStakeHolderMember : this.caseStakeHolderMembers) {
                caseStakeHolderAsAString.append(caseStakeHolderMember.toString((prefix != null ? prefix : "") + "\t"));
            }
        }
        if (this.getComment() != null) {
            caseStakeHolderAsAString.append(this.getComment().toString((prefix != null ? prefix : "") + "\t"));
        }
        return caseStakeHolderAsAString.toString();
    }
}

