/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.factory;

import java.util.ArrayList;
import java.util.Map;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.metadata.event.model.TDocumentEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.metadata.event.model.TLifecycleEvent;
import oracle.bpm.casemgmt.metadata.event.model.TMilestoneEvent;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.PropertyBag;

public class CaseEventFactory {
    public static CaseEvent createCaseActivityEvent(TActivityEvent activityEventType, String activityType, String activityName, String activityId, Map<String, String> propertyBag, Comment comment) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setCommentShared(false);
        ce.setEventType(TEventType.ACTIVITY_EVENT);
        ce.setActivityType(activityType);
        ce.setActivityName(activityName);
        ce.setActivityId(activityId);
        ce.setActivityEvent(activityEventType);
        return ce;
    }

    public static CaseEvent createCaseLifecycleEvent(TLifecycleEvent lifeCycleEventType, Map<String, String> propertyBag, Comment comment) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setEventType(TEventType.LIFECYCLE_EVENT);
        ce.setLifecycleEvent(lifeCycleEventType);
        return ce;
    }

    public static CaseEvent createCaseDocumentEvent(TDocumentEvent documentEventType, String documentName, String documentVersion, String documentId, Map<String, String> propertyBag, Comment comment) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setEventType(TEventType.DOCUMENT_EVENT);
        ce.setDocumentEvent(documentEventType);
        ce.setDocumentName(documentName);
        ce.setDocumentVersion(documentVersion);
        ce.setDocumentId(documentId);
        return ce;
    }

    public static CaseEvent createCaseMilestoneEvent(Comment comment, Map<String, String> propertyBag, TMilestoneEvent milestoneEventType, String milestoneName) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setEventType(TEventType.MILESTONE_EVENT);
        ce.setMilestoneEvent(milestoneEventType);
        ce.setMilestone(milestoneName);
        return ce;
    }

    public static CaseEvent createCaseCommentEvent(Comment comment, Map<String, String> propertyBag) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setEventType(TEventType.COMMENT_EVENT);
        ce.setCommentEventComment(comment.getCaseObjectComment());
        return ce;
    }

    public static CaseEvent createCaseDataEvent(Comment comment, Map<String, String> propertyBag, String dataName) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setEventType(TEventType.DATA_UPLOAD_EVENT);
        ce.setDataName(dataName);
        return ce;
    }

    public static CaseEvent createUserDefinedEvent(String userDefinedEvent, Map<String, String> propertyBag, Comment comment) {
        CaseEvent ce = CaseEventFactory.createCaseEvent(comment, propertyBag);
        ce.setCommentShared(false);
        ce.setEventType(TEventType.USER_DEFINED_EVENT);
        ce.setUserDefinedEvent(userDefinedEvent);
        return ce;
    }

    private static CaseEvent createCaseEvent(Comment comment, Map<String, String> propertyBag) {
        CaseEvent ce = new CaseEvent();
        ce.setComment(comment);
        ce.setObjectType(ICaseConstants.CaseObjectType.EVENT.name());
        CaseEventFactory.setPropertyBag(ce, propertyBag);
        return ce;
    }

    private static void setPropertyBag(CaseEvent ce, Map<String, String> propertyBag) {
        ArrayList<PropertyBag> propertyBagCollection = new ArrayList<PropertyBag>();
        ce.setPropertyBagCollection(propertyBagCollection);
        if (propertyBag == null) {
            return;
        }
        for (String key : propertyBag.keySet()) {
            String value = propertyBag.get(key);
            PropertyBag pBag = new PropertyBag(ce, key, value);
            ce.addPropertyBag(pBag);
        }
    }
}

