/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.factory;

import java.util.Properties;
import javax.naming.InitialContext;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseServiceLocator {
    public static String JNDI_CREDENTIALS = null;

    public static ICaseService getCaseService() {
        return (ICaseService)CaseServiceLocator.jndiLookup("ejb.bpm.case.CaseService");
    }

    public static Object jndiLookup(String jndiName) {
        return CaseServiceLocator.jndiLookup(null, null, null, JNDI_CREDENTIALS, jndiName);
    }

    public static Object jndiLookup(String host, String port, String user, String cred, String jndiName) {
        Object obj = null;
        Properties properties = new Properties();
        if (cred != null) {
            properties.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            if (host == null) {
                host = "localhost";
            }
            if (port == null) {
                port = "7001";
            }
            if (user == null) {
                user = "weblogic";
            }
            properties.put("java.naming.provider.url", "t3://" + host + ":" + port);
            properties.put("java.naming.security.principal", user);
            properties.put("java.naming.security.credentials", cred);
        }
        try {
            InitialContext context = new InitialContext(properties);
            obj = context.lookup(jndiName);
            if (obj != null) {
                CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, "jndiLookup(): object = " + obj.getClass().getName());
            }
        }
        catch (Exception e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.ERRORS, CaseServiceLocator.class.getName(), "jndiLookup", e);
        }
        return obj;
    }
}

