/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.common.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseLogger {
    private CaseLogger() {
    }

    public static void log(LoggerComponent component, Severity severity, String className, String methodName, String message) {
        Logger logger = component.logger();
        if (CaseLogger.canLog(component, severity) && message != null) {
            logger.logp(severity.level(), className, methodName, message);
        }
    }

    public static void log(LoggerComponent component, Severity severity, String message) {
        Logger logger = component.logger();
        if (CaseLogger.canLog(component, severity) && message != null) {
            Thread thread = Thread.currentThread();
            StackTraceElement[] framesArray = thread.getStackTrace();
            String className = null;
            String methodName = null;
            if (framesArray.length > 0) {
                StackTraceElement stackFrame = framesArray[1];
                className = stackFrame.getClassName();
                methodName = stackFrame.getMethodName();
            }
            logger.logp(severity.level(), className, methodName, message);
        }
    }

    public static void log(LoggerComponent component, Severity severity, String sourceClass, String sourceMethod, Throwable thrown) {
        CaseLogger.log(component, severity, sourceClass, sourceMethod, "Exception", thrown);
    }

    public static void log(LoggerComponent component, Severity severity, String sourceClass, String sourceMethod, String message, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        if (CaseLogger.canLog(component, severity)) {
            Logger logger = component.logger();
            logger.logp(severity.level(), sourceClass, sourceMethod, message, thrown);
        }
    }

    public static boolean canLog(LoggerComponent component, Severity severity) {
        return Level.OFF != severity.level() && component.logger().isLoggable(severity.level());
    }
}

