/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.common.exception;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpm.casemgmt.common.exception.AbstractCaseException;
import oracle.bpm.casemgmt.common.exception.i18n.CaseServiceExceptionBundle;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.common.resources.i18n.CaseManagementResourceBundle;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseExceptionUtil {
    private Locale locale;
    private MessageParts part = new MessageParts();
    private ListResourceBundle resourceBundle = null;
    private static final long serialVersionUID = 1L;
    private static String resourceBundleName = CaseServiceExceptionBundle.class.getName();
    private static Map<String, ListResourceBundle> resourceBundleMap = new HashMap<String, ListResourceBundle>();

    public CaseExceptionUtil() {
        this.loadResourceBundle();
    }

    public static String lookupKey(ResourceBundle bundle, String key) {
        if (bundle == null || key == null) {
            return null;
        }
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            CaseLogger.log(LoggerComponent.COMPONENT_CM_COMMON, Severity.DEBUG, CaseExceptionUtil.class.getClass().getName(), "lookupKey", e);
        }
        return value;
    }

    public static String lookupKeyFromCaseBundleInDefaultLocale(String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(CaseManagementResourceBundle.class.getName(), Locale.getDefault());
            String value = CaseExceptionUtil.lookupKey(bundle, key);
            if (value == null || value.isEmpty()) {
                return key;
            }
            return value;
        }
        catch (Exception e) {
            return key;
        }
    }

    public String getDisplayMessage(int errorCode, Object[] args) {
        this.setMessageAttributes(errorCode, args);
        StringBuffer buf = new StringBuffer();
        if (this.part.name != null) {
            buf.append(this.part.name);
            if (!this.part.name.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.part.description != null) {
            buf.append(this.part.description);
            if (!this.part.description.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.part.fix != null) {
            buf.append(this.part.fix);
            if (!this.part.fix.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public void localizeException(Throwable t, Locale locale) {
        if (locale == null) {
            return;
        }
        this.setLocale(locale);
        while (t != null && t instanceof AbstractCaseException) {
            if (locale.equals(((AbstractCaseException)t).getLocale())) {
                t = t.getCause();
                continue;
            }
            int errorCode = ((AbstractCaseException)t).getErrorCode();
            Object[] args = ((AbstractCaseException)t).getArguments();
            ((AbstractCaseException)t).setLocale(locale);
            ((AbstractCaseException)t).setMessage(this.getDisplayMessage(errorCode, args));
            t = t.getCause();
        }
    }

    void setLocale(Locale locale) {
        this.locale = locale;
        this.loadResourceBundle();
    }

    Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    void loadResourceBundle() {
        if (resourceBundleMap.containsKey(this.getLocale().toString())) {
            this.resourceBundle = resourceBundleMap.get(this.getLocale().toString());
        } else {
            this.resourceBundle = (ListResourceBundle)ResourceBundle.getBundle(resourceBundleName, this.getLocale());
            resourceBundleMap.put(this.getLocale().toString(), this.resourceBundle);
        }
    }

    private void setMessageAttributes(int errorCode, Object[] args) {
        this.part.errorCode = errorCode;
        MessageParts.access$402(this.part, args);
        this.part.prefix = "exception." + errorCode;
        this.part.severity = CaseExceptionUtil.lookupKey(this.resourceBundle, this.part.prefix + ".severity");
        this.part.type = CaseExceptionUtil.lookupKey(this.resourceBundle, this.part.prefix + ".type");
        String value = CaseExceptionUtil.lookupKey(this.resourceBundle, this.part.prefix + ".name");
        if (value != null) {
            this.part.name = MessageFormat.format(value, this.part.arguments);
        }
        if ((value = CaseExceptionUtil.lookupKey(this.resourceBundle, this.part.prefix + ".description")) != null) {
            this.part.description = MessageFormat.format(value, this.part.arguments);
        }
        if ((value = CaseExceptionUtil.lookupKey(this.resourceBundle, this.part.prefix + ".fix")) != null) {
            this.part.fix = MessageFormat.format(value, this.part.arguments);
        }
    }

    class MessageParts {
        private Object[] arguments;
        private String description = null;
        private int errorCode;
        private String fix = null;
        private String name = null;
        private String prefix = "exception.";
        private String severity = null;
        private String type = null;

        MessageParts() {
        }

        static /* synthetic */ Object[] access$402(MessageParts x0, Object[] x1) {
            x0.arguments = x1;
            return x1;
        }
    }
}

