/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caseactivity.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import oracle.bpel.services.workflow.metadata.processDocumentation.model.DocumentationType;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityCategoryDefinition;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInCaseDefinition;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.task.model.TaskInfo;

@Entity
@NamedQueries(value={@NamedQuery(name="CaseActivityDefinition.findAll", query="select o from CaseActivityDefinition o"), @NamedQuery(name="CaseActivityDefinition.deleteAll", query="delete from CaseActivityDefinition"), @NamedQuery(name="CaseActivityDefinition.findById", query="select o from CaseActivityDefinition o where o.definitionId IN :definitionId"), @NamedQuery(name="CaseActivityDefinition.findByCategory", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn, IN(caseActivityDefn.caseActivityCategoryDefinitionList) categoryDefn where categoryDefn.category IN :categoryName"), @NamedQuery(name="CaseActivityDefinition.findByCaseDefinitionId", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn, IN(caseActivityDefn.caseActivityInCaseDefinitionList) caseAssociation WHERE caseAssociation.caseDefinitionId IN :caseDefinitionId"), @NamedQuery(name="CaseActivityDefinition.findIfAutomaticActivity", query="select o from CaseActivityDefinition o where o.isManual = 'N' and o.definitionId = :definitionId"), @NamedQuery(name="CaseActivityDefinition.findAllAutomaticActivitiesForCategory", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityCategoryDefinitionList categoryDefn where categoryDefn.category = :categoryName and caseActivityDefn.isManual = 'N' and caseActivityDefn.isConditional = 'N'"), @NamedQuery(name="CaseActivityDefinition.findAllManualActivitiesForCategory", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityCategoryDefinitionList categoryDefn where categoryDefn.category = :categoryName and caseActivityDefn.isManual = 'Y' and caseActivityDefn.isConditional = 'N'"), @NamedQuery(name="CaseActivityDefinition.findAllAutomaticActivitiesForCase", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityInCaseDefinitionList caseAssociation WHERE caseAssociation.caseDefinitionId = :caseDefinitionId and caseActivityDefn.isManual = 'N' and caseActivityDefn.isConditional = 'N'"), @NamedQuery(name="CaseActivityDefinition.findAllManualActivitiesForCase", query="select caseActivityDefn from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityInCaseDefinitionList caseAssociation WHERE caseAssociation.caseDefinitionId = :caseDefinitionId and caseActivityDefn.isManual = 'Y' and caseActivityDefn.isConditional = 'N'"), @NamedQuery(name="CaseActivityDefinition.findAllAutomaticActivitiesWithoutAssociations", query="select o from CaseActivityDefinition o where o.isManual = 'N' and o.isCaseSpecific = 'N' and o.isConditional = 'N' "), @NamedQuery(name="CaseActivityDefinition.findAllManualActivitiesWithoutAssociations", query="select o from CaseActivityDefinition o where o.isManual = 'Y' and o.isCaseSpecific = 'N' and o.isConditional = 'N' "), @NamedQuery(name="CaseActivityDefinition.findActivityWithoutAssociationsFromName", query="select o from CaseActivityDefinition o where o.isCaseSpecific = 'N' and  o.name = :name"), @NamedQuery(name="CaseActivityDefinition.findActivityForCaseFromName", query="select o from CaseActivityDefinition o  JOIN o.caseActivityInCaseDefinitionList caseAssociation  where o.isCaseSpecific = 'Y' and  o.name = :name and caseAssociation.caseDefinitionId = :caseDefinitionId"), @NamedQuery(name="CaseActivityDefinition.findActivityForCategoryFromName", query="select o from CaseActivityDefinition o  JOIN o.caseActivityCategoryDefinitionList categoryDefn  where o.isCaseSpecific = 'Y' and  o.name = :name and categoryDefn.category = :categoryName"), @NamedQuery(name="CaseActivityDefinition.findActivityWithoutAssociationsFromNameVersion", query="select o from CaseActivityDefinition o where o.isCaseSpecific = 'N' and  o.name = :name and o.compositeVersion = :version "), @NamedQuery(name="CaseActivityDefinition.findActivityForCaseFromNameVersion", query="select o from CaseActivityDefinition o  JOIN o.caseActivityInCaseDefinitionList caseAssociation  where o.isCaseSpecific = 'Y' and  o.name = :name and caseAssociation.caseDefinitionId = :caseDefinitionId  and o.compositeVersion = :version"), @NamedQuery(name="CaseActivityDefinition.findActivityForCategoryFromNameVersion", query="select o from CaseActivityDefinition o  JOIN o.caseActivityCategoryDefinitionList categoryDefn  where o.isCaseSpecific = 'Y' and  o.name = :name and categoryDefn.category = :categoryName  and o.compositeVersion = :version"), @NamedQuery(name="CaseActivityDefinition.findRequiredActivitiesWithoutAssociations", query="select o.definitionId from CaseActivityDefinition o where o.isRequired = 'Y' and o.isCaseSpecific = 'N' "), @NamedQuery(name="CaseActivityDefinition.findRequiredActivitiesForCategory", query="select caseActivityDefn.definitionId from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityCategoryDefinitionList categoryDefn where categoryDefn.category = :categoryName and caseActivityDefn.isRequired = 'Y' and caseActivityDefn.isCaseSpecific = 'Y'"), @NamedQuery(name="CaseActivityDefinition.findRequiredActivitiesForCase", query="select caseActivityDefn.definitionId from CaseActivityDefinition caseActivityDefn JOIN caseActivityDefn.caseActivityInCaseDefinitionList caseAssociation WHERE caseAssociation.caseDefinitionId = :caseDefinitionId and caseActivityDefn.isRequired = 'Y' and caseActivityDefn.isCaseSpecific = 'Y'")})
@Table(name="CM_ACTIVITY_DEFINITION")
public class CaseActivityDefinition
implements Serializable,
Cloneable {
    @Column(name="APPLICATION_NAME", length=200)
    private String applicationName;
    @OneToMany(mappedBy="caseActivityDefinition", cascade={CascadeType.ALL})
    private List<CaseActivityCategoryDefinition> caseActivityCategoryDefinitionList;
    @Transient
    private String caseActivityFormUrl;
    @OneToMany(mappedBy="caseActivityDefinition", cascade={CascadeType.ALL})
    private List<CaseActivityInCaseDefinition> caseActivityInCaseDefinitionList;
    @Transient
    private String caseId;
    @Column(name="CLASS_NAME", length=2000)
    private String className;
    @Transient
    private Calendar completedDate;
    @Column(name="COMPONENT_NAME", length=200)
    private String componentName;
    @Column(name="COMPOSITE_DN", length=500)
    private String compositeDn;
    @Column(name="COMPOSITE_NAME", length=200)
    private String compositeName;
    @Column(name="COMPOSITE_VERSION", length=10)
    private String compositeVersion;
    @Column(name="DEFINITION_ID", nullable=false, length=200)
    @Id
    private String definitionId;
    @Column(length=1000)
    private String description;
    @Column(name="DISPLAY_NAME", length=255)
    private String displayName;
    @Transient
    private List<DocumentationType> documentations;
    @Transient
    private String eventId;
    @Transient
    private String instanceId;
    @Column(name="IS_CASE_SPECIFIC", length=1)
    private String isCaseSpecific;
    @Column(name="IS_CONDITIONAL", length=1)
    private String isConditional;
    @Column(name="IS_CUSTOM", length=1)
    private String isCustom;
    @Transient
    private boolean isFormRequired;
    @Column(name="IS_GLOBAL", length=1)
    private String isGlobal;
    @Column(name="IS_MANUAL", length=1)
    private String isManual;
    @Column(name="IS_REPEATABLE", length=1)
    private String isRepeatable;
    @Column(name="IS_REQUIRED", length=1)
    private String isRequired;
    @Column(nullable=false)
    private String name;
    @Column(length=2000)
    private String namespace;
    @Lob
    private char[] payload;
    @Column(name="PERMISSION_TAG", length=255)
    private String permissionTag;
    @Column(name="PRODUCT_VERSION", length=200)
    private String productVersion;
    @Transient
    private ICaseConstants.ActivityRelevance relevance = ICaseConstants.ActivityRelevance.NONE;
    @Transient
    private Calendar startDate;
    @Transient
    private String state;
    @Transient
    private TaskInfo taskInfo;
    @Column(length=500)
    private String title;
    @Column(nullable=false)
    private String type;
    @Transient
    private List<DocumentationType> useCaseDocumentations;
    private static final long serialVersionUID = 4088773418964375695L;

    public CaseActivityDefinition() {
    }

    public CaseActivityDefinition(String applicationName, String className, String componentName, String compositeDn, String compositeName, String compositeVersion, String custom, String definitionId, String description, String isGlobal, String isCaseSpecific, String isConditional, String manual, boolean isFormRequired, String name, String namespace, String repeatable, String required, String title, String type, String permissionTag, String productVersion) {
        this.applicationName = applicationName;
        this.className = className;
        this.componentName = componentName;
        this.compositeDn = compositeDn;
        this.compositeName = compositeName;
        this.compositeVersion = compositeVersion;
        this.isCustom = custom;
        this.definitionId = definitionId;
        this.description = description;
        this.isGlobal = isGlobal;
        this.isCaseSpecific = isCaseSpecific;
        this.isConditional = isConditional;
        this.isManual = manual;
        this.isFormRequired = isFormRequired;
        this.name = name;
        this.namespace = namespace;
        this.isRepeatable = repeatable;
        this.isRequired = required;
        this.title = title;
        this.type = type;
        this.productVersion = productVersion;
        this.permissionTag = permissionTag;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Calendar getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Calendar completedDate) {
        this.completedDate = completedDate;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getCompositeDn() {
        return this.compositeDn;
    }

    public void setCompositeDn(String compositeDn) {
        this.compositeDn = compositeDn;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public void setCompositeName(String compositeName) {
        this.compositeName = compositeName;
    }

    public String getCompositeVersion() {
        return this.compositeVersion;
    }

    public void setCompositeVersion(String compositeVersion) {
        this.compositeVersion = compositeVersion;
    }

    public boolean getIsCustom() {
        return CaseActivityDefinition.convertStringToBoolean(this.isCustom);
    }

    public void setIsCustom(boolean custom) {
        this.isCustom = CaseActivityDefinition.convertBooleanToString(custom);
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean getIsGlobal() {
        return CaseActivityDefinition.convertStringToBoolean(this.isGlobal);
    }

    public void setIsGlobal(boolean isGlobal) {
        this.isGlobal = CaseActivityDefinition.convertBooleanToString(isGlobal);
    }

    public boolean getIsCaseSpecific() {
        return CaseActivityDefinition.convertStringToBoolean(this.isCaseSpecific);
    }

    public void setIsCaseSpecific(boolean isCaseSpecific) {
        this.isCaseSpecific = CaseActivityDefinition.convertBooleanToString(isCaseSpecific);
    }

    public boolean getIsConditional() {
        return CaseActivityDefinition.convertStringToBoolean(this.isConditional);
    }

    public void setIsConditional(boolean isConditional) {
        this.isConditional = CaseActivityDefinition.convertBooleanToString(isConditional);
    }

    public List<DocumentationType> getDocumentations() {
        return this.documentations;
    }

    public void setDocumentations(List<DocumentationType> documentations) {
        this.documentations = documentations;
    }

    public boolean getIsManual() {
        return CaseActivityDefinition.convertStringToBoolean(this.isManual);
    }

    public void setIsManual(boolean manual) {
        this.isManual = CaseActivityDefinition.convertBooleanToString(manual);
    }

    public boolean getIsFormRequired() {
        return this.isFormRequired;
    }

    public void setIsFormRequired(boolean isFormRequired) {
        this.isFormRequired = isFormRequired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public char[] getPayload() {
        return this.payload;
    }

    public void setPayload(char[] payload) {
        this.payload = payload;
    }

    public String getPermissionTag() {
        return this.permissionTag;
    }

    public void setPermissionTag(String permissionTag) {
        this.permissionTag = permissionTag;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public boolean getIsRepeatable() {
        return CaseActivityDefinition.convertStringToBoolean(this.isRepeatable);
    }

    public void setIsRepeatable(boolean repeatable) {
        this.isRepeatable = CaseActivityDefinition.convertBooleanToString(repeatable);
    }

    public boolean getIsRequired() {
        return CaseActivityDefinition.convertStringToBoolean(this.isRequired);
    }

    public void setIsRequired(boolean required) {
        this.isRequired = CaseActivityDefinition.convertBooleanToString(required);
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRelevance(ICaseConstants.ActivityRelevance relevance) {
        this.relevance = relevance;
    }

    public ICaseConstants.ActivityRelevance getRelevance() {
        return this.relevance;
    }

    public List<DocumentationType> getUseCaseDocumentations() {
        return this.useCaseDocumentations;
    }

    public void setUseCaseDocumentations(List<DocumentationType> useCaseDocumentations) {
        this.useCaseDocumentations = useCaseDocumentations;
    }

    public List<CaseActivityCategoryDefinition> getCaseActivityCategoryDefinitionList() {
        return this.caseActivityCategoryDefinitionList;
    }

    public void setCaseActivityCategoryDefinitionList(List<CaseActivityCategoryDefinition> caseActivityCategoryDefinitionList) {
        this.caseActivityCategoryDefinitionList = caseActivityCategoryDefinitionList;
    }

    public String getCaseActivityFormUrl() {
        return this.caseActivityFormUrl;
    }

    public void setCaseActivityFormUrl(String caseActivityFormUrl) {
        this.caseActivityFormUrl = caseActivityFormUrl;
    }

    public CaseActivityCategoryDefinition addCaseActivityCategoryDefinition(CaseActivityCategoryDefinition caseActivityCategoryDefinition) {
        this.getCaseActivityCategoryDefinitionList().add(caseActivityCategoryDefinition);
        caseActivityCategoryDefinition.setCaseActivityDefinition(this);
        return caseActivityCategoryDefinition;
    }

    public CaseActivityCategoryDefinition removeCaseActivityCategoryDefinition(CaseActivityCategoryDefinition caseActivityCategoryDefinition) {
        this.getCaseActivityCategoryDefinitionList().remove(caseActivityCategoryDefinition);
        caseActivityCategoryDefinition.setCaseActivityDefinition(null);
        return caseActivityCategoryDefinition;
    }

    public List<CaseActivityInCaseDefinition> getCaseActivityInCaseDefinitionList() {
        return this.caseActivityInCaseDefinitionList;
    }

    public void setCaseActivityInCaseDefinitionList(List<CaseActivityInCaseDefinition> caseActivityInCaseDefinitionList) {
        this.caseActivityInCaseDefinitionList = caseActivityInCaseDefinitionList;
    }

    public CaseActivityInCaseDefinition addCaseActivityInCaseDefinition(CaseActivityInCaseDefinition caseActivityInCaseDefinition) {
        this.getCaseActivityInCaseDefinitionList().add(caseActivityInCaseDefinition);
        caseActivityInCaseDefinition.setCaseActivityDefinition(this);
        return caseActivityInCaseDefinition;
    }

    public CaseActivityInCaseDefinition removeCaseActivityInCaseDefinition(CaseActivityInCaseDefinition caseActivityInCaseDefinition) {
        this.getCaseActivityInCaseDefinitionList().remove(caseActivityInCaseDefinition);
        caseActivityInCaseDefinition.setCaseActivityDefinition(null);
        return caseActivityInCaseDefinition;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static boolean convertStringToBoolean(String stringValue) {
        return stringValue != null && stringValue.equalsIgnoreCase("Y");
    }

    private static String convertBooleanToString(boolean booleanValue) {
        if (booleanValue) {
            return "Y";
        }
        return "N";
    }
}

