/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.compiler.IDebuggerRunnable;
import oracle.bpm.component.Component;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.editor.WebDebuggerDialog;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.WebContainerMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.WebRoot;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.WindowAdapter;
import oracle.bpm.ui.event.WindowEvent;
import oracle.bpm.ui.event.WindowListener;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.util.WebContainer;
import oracle.bpm.util.WebContainerException;

public abstract class WebDebuggerClient {
    private WebDebuggerDialog browserDialog;
    private IDebuggerRunnable debuggerRunnable;
    private Project project;
    private boolean visible;
    private static WebDebuggerClient currentDebugger;
    private static String WEB_DEBUGGER_CONTEXT_PATH;
    public static WebContainer webContainer;

    public WebDebuggerClient(Project project) {
        this.project = project;
    }

    public static void setDebugger(WebDebuggerClient debugger) {
        currentDebugger = debugger;
    }

    public static WebDebuggerClient getInstance() {
        return currentDebugger;
    }

    public Project getProject() {
        return this.project;
    }

    public ComponentCatalog getComponentCatalog() {
        return this.project.getComponentCatalog();
    }

    public void beginDebugging() {
        Environment.init(this.project);
        try {
            URL url = new URL("http://localhost:" + WebDebuggerClient.getWebDebuggerPort() + '/' + WEB_DEBUGGER_CONTEXT_PATH + "/servlet/debugger?redirect=reset");
            this.initBrowserDialog(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not connect to Web Debbuger", e);
        }
    }

    public IDebuggerRunnable runCurrent() {
        return this.initDebugger();
    }

    public void finishDebugging() {
        this.browserDialog.finish();
    }

    public IDebuggerRunnable getDebuggerRunnable() {
        return this.debuggerRunnable;
    }

    public void setDebuggerRunnable(IDebuggerRunnable debbugerRunnable) {
        this.debuggerRunnable = debbugerRunnable;
    }

    public void displayBrowser() {
        if (Log.isDebugging()) {
            Log.logDebug("Show debug browser dialog.");
        }
        this.visible = true;
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebDebuggerClient.this.getBrowserDialog().setVisible(true);
            }
        });
    }

    public void hideBrowser() {
        if (this.visible) {
            this.visible = false;
            if (Log.isDebugging()) {
                Log.logDebug("Hide debug browser dialog.");
            }
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebDebuggerClient.this.getBrowserDialog().setVisible(false);
                }
            });
        }
    }

    protected abstract IDebuggerRunnable initDebugger();

    private static int getWebDebuggerPort() {
        return EditorPreferences.getInstance().getWebDebuggerPort();
    }

    private void initBrowserDialog(final URL url) {
        UiUtilities.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                WebDebuggerClient.this.browserDialog = new WebDebuggerDialog();
                WebDebuggerClient.this.browserDialog.setUrl(url);
                WebDebuggerClient.this.browserDialog.makeRecyclable();
                WebDebuggerClient.this.browserDialog.addWindowListener((WindowListener)new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        if (Log.isDebugging()) {
                            Log.logDebug("Finish current debug execution.");
                        }
                        if (WebDebuggerClient.this.debuggerRunnable != null) {
                            WebDebuggerClient.this.debuggerRunnable.finishExecution();
                        }
                    }
                });
                WebDebuggerClient.this.visible = false;
            }
        });
    }

    private WebDebuggerDialog getBrowserDialog() {
        return this.browserDialog;
    }

    static {
        WEB_DEBUGGER_CONTEXT_PATH = "webdebugger";
    }

    private static class Environment {
        private Environment() {
        }

        public static void init(Project project) {
            if (Environment.isWebContainerStarted()) {
                Environment.initWebContainer();
            }
            Environment.copyProjectJSPResources(project);
        }

        public static void copyProjectJSPResources(Project project) {
            String webDebuggerDir = FuegoDirectories.webAppsInstallation() + "webdebugger";
            if (Log.isDebugging()) {
                Log.logDebug("Copying JSP files and resources to:" + webDebuggerDir);
            }
            File webdebbugerDir = new File(webDebuggerDir);
            FileProjectWriter projectWriter = (FileProjectWriter)project.getWriter();
            WebRoot.copyWebRootTo((ProjectWriter)projectWriter, (File)webdebbugerDir);
        }

        private static boolean isWebContainerStarted() {
            return webContainer == null;
        }

        private static void initWebContainer() {
            final Any.Holder holder = new Any.Holder();
            UiUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorGUI monitor = ProgressMonitorBuilder.createSimpleBuilder((UiContainer)Ui.getRoot()).buildProgressMonitor((UiContainer)Ui.getRoot());
                    holder.value = monitor;
                }
            });
            final ProgressMonitor monitor = (ProgressMonitor)holder.value;
            monitor.info(EditorMsg.START_WEB_CONTAINER_DEBUGGER);
            monitor.progress(-1);
            FuegoWorker.post((FuegoJob)new FuegoJob<Object>(){

                public Object run() {
                    monitor.progress(0);
                    Environment.startWebContainer();
                    monitor.progress(100);
                    return null;
                }
            });
        }

        private static void startWebContainer() throws WebContainerException {
            try {
                Extension<WebContainerMetadata> extension;
                Component.setLocation("CLIENT");
                List<Extension<WebContainerMetadata>> containers = Platform.getExtensionService().getExtensionsByPoint(WebContainerMetadata.class);
                assert (!containers.isEmpty()) : "Cannot find any extension of " + WebContainerMetadata.class;
                WebContainer container = null;
                Iterator<Extension<WebContainerMetadata>> i$ = containers.iterator();
                while (i$.hasNext() && (container = (extension = i$.next()).instantiateAs(WebContainer.class)).getClass().getName().indexOf("Debug") == -1) {
                }
                assert (container != null) : "Cannot find web container extension for debug:" + WebContainerMetadata.class;
                container.init();
                container.addConnector(InetAddress.getByName("localhost"), WebDebuggerClient.getWebDebuggerPort());
                String docBase = FuegoDirectories.webAppsInstallation() + WEB_DEBUGGER_CONTEXT_PATH;
                container.addWebApplication(docBase, "/" + WEB_DEBUGGER_CONTEXT_PATH);
                container.start();
                webContainer = container;
            }
            catch (UnknownHostException e) {
                Environment.stopWebContainer();
                throw new IllegalStateException("Could not start Web ContainerServer", e);
            }
            catch (InstantiationException e) {
                Environment.stopWebContainer();
                throw new IllegalStateException("Could not start Web ContainerServer", e);
            }
            catch (WebContainerException exception) {
                Environment.stopWebContainer();
                throw exception;
            }
        }

        private static void stopWebContainer() {
            if (webContainer != null) {
                try {
                    webContainer.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                webContainer = null;
            }
        }
    }
}

