/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.draw.Font;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;

public class SuggestionRenderer {
    private Image attributeIcon;
    private Font boldFont;
    private String currentPrefix = "";
    private Font font;
    private Image icon;
    private Image methodIcon = Image.create((Msg)ProjectMsg.METHOD);
    private String name;
    private Font normalFont;
    private CompletionSuggestion suggestion;
    private Image transformIcon;
    private TypeRenderer typeRenderer;
    private String typeText;
    private boolean useHtml = true;
    private static final int STRIKE = 1;
    private static final int BOLD = 2;
    private static final int SELECTED = 4;

    public SuggestionRenderer(LanguageSpec langSpec) {
        this.attributeIcon = Image.create((Msg)ProjectMsg.ATTRIBUTE);
        this.transformIcon = Image.create((Msg)ProjectMsg.TRANSFORMATION);
        this.typeRenderer = langSpec.getTypeRenderer();
    }

    public void setBoldFont(Font boldFont) {
        this.boldFont = boldFont;
    }

    public void setCurrentPrefix(String prefix) {
        this.currentPrefix = prefix;
    }

    public String getCurrentPrefix() {
        return this.currentPrefix;
    }

    public Font getFont() {
        return this.font;
    }

    public String getFullPrefix() {
        return this.suggestion.getCompletionId() + this.currentPrefix;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public void setUseHtml(boolean useHtml) {
        this.useHtml = useHtml;
    }

    public boolean isUseHtml() {
        return this.useHtml;
    }

    public void render(CompletionSuggestion suggestion) {
        String prefix;
        int prefixLength;
        int style;
        String typeText;
        this.suggestion = suggestion;
        String name = suggestion.getId();
        TypeDescription suggestionType = suggestion.getType();
        Font font = this.normalFont;
        Image icon = null;
        StringBuilder text = new StringBuilder(32);
        if (suggestionType != null) {
            if (suggestionType.isMember() || suggestionType.isTransformation()) {
                MethodTypeDescription member = suggestionType.asMethod();
                text.append(member.getName());
                if (!member.isAttribute()) {
                    this.typeRenderer.renderArguments(member, null, text);
                }
                typeText = this.typeRenderer.render((TypeRef)member.getResultType());
                name = text.toString();
                icon = suggestionType.isAttribute() ? this.attributeIcon : (suggestionType.isMethod() ? this.methodIcon : this.transformIcon);
                text.setLength(0);
            } else {
                typeText = this.typeRenderer.render((TypeRef)suggestionType);
            }
        } else {
            typeText = "";
        }
        boolean isDeprecated = suggestionType != null && Modifier.isDeprecated(suggestionType.getModifiers());
        int n = style = isDeprecated ? 1 : 0;
        if (suggestionType == null) {
            style |= 2;
        }
        int threshold = Math.max(40, 100 - typeText.length() - 1);
        if (name.length() > threshold) {
            int breakIndex = (name = name.substring(0, threshold)).lastIndexOf(44);
            if (breakIndex == -1 || breakIndex < threshold - 10) {
                breakIndex = name.lastIndexOf(32);
            }
            if (breakIndex != -1 && breakIndex >= threshold - 10) {
                name = name.substring(0, breakIndex + 1);
            }
            name = name + "...";
        }
        if ((prefixLength = (prefix = this.getFullPrefix()).length()) > 0) {
            int length = name.length();
            String selected = name.substring(0, Math.min(length, prefixLength));
            String rest = prefixLength < length ? name.substring(prefixLength) : "";
            String highlightedName = this.style(selected, 4) + rest;
            String styled = this.style(highlightedName, style);
            name = this.isUseHtml() ? "<html>" + styled : styled;
        } else if (style == 2) {
            font = this.boldFont;
        } else {
            name = style != 0 ? "<html>" + this.style(name, style) : name;
        }
        this.setName(name);
        this.setTypeText(typeText);
        this.setIcon(icon);
        this.setFont(font);
    }

    void setFont(Font font) {
        this.font = font;
    }

    void setIcon(Image icon) {
        this.icon = icon;
    }

    void setName(String name) {
        this.name = name;
    }

    void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    private String style(String text, int style) {
        if (this.isUseHtml()) {
            if ((style & 1) != 0) {
                text = "<strike>" + text + "</strike>";
            }
            if ((style & 2) != 0) {
                text = "<b>" + text + "</b>";
            }
            if ((style & 4) != 0) {
                text = "<font color=purple>" + text + "</font>";
            }
        }
        return text;
    }
}

