/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class EditorPreferences
implements Serializable {
    boolean autoCompleteDelayEnabled = true;
    private int autoCompleteDelay = 1000;
    private boolean commit;
    private int componentBrowserOrientation = 0;
    private int intSyntax = -1;
    private String language = "Fuego";
    private ArrayList<String> lastFindWords = new ArrayList();
    private ArrayList<String> lastReplaceWords = new ArrayList();
    private WeakHashMap<PropertyChangeListener, Object> listeners = new WeakHashMap();
    private String path = null;
    private transient TypeRenderer renderer;
    private String syntax;
    private int webDebuggerPort;
    private static final int DEFAULT_WEB_DEBUGGER_PORT = 9595;
    private static final File EDITOR_PREFERENCES_FILE = FuegoDirectories.homeRelativeFile("cilEditorPreferences");
    static final long serialVersionUID = 1282486899596456149L;
    private static final Object PRESENT = new Object();
    public static final String VERBOSE = "verbose";
    public static final String OO = "Object.method";
    public static final String FUNCTIONAL = "functional";
    private static EditorPreferences instance;
    public static final int COMPONENT_BROWSER_HORIZONTAL = 0;
    public static final int COMPONENT_BROWSER_VERTICAL = 1;
    public static final int VERBOSE_SYNTAX = 0;
    public static final int OO_SYNTAX = 1;
    public static final int FUNCTIONAL_SYNTAX = 2;
    static final long serialCheck = 8300537507461036898L;

    private EditorPreferences() {
        this.restoreToDefault();
    }

    public static EditorPreferences getInstance() {
        if (instance == null) {
            EditorPreferences.load();
        }
        return instance;
    }

    public void setAutoCompleteDelay(int delay) {
        this.autoCompleteDelay = delay;
    }

    public int getAutoCompleteDelay() {
        return this.autoCompleteDelay;
    }

    public void setAutoCompleteDelayEnabled(boolean b) {
        this.autoCompleteDelayEnabled = b;
    }

    public boolean getAutoCompleteDelayEnabled() {
        return this.autoCompleteDelayEnabled;
    }

    public void setCommit(boolean commit) {
        if (this.commit != commit) {
            this.fireEvent("commit", this.commit, commit);
            this.commit = commit;
        }
    }

    public void setWebDebuggerPort(int webDebuggerPort) {
        if (this.webDebuggerPort != webDebuggerPort) {
            this.fireEvent("webDebuggerPort", webDebuggerPort, webDebuggerPort);
            this.webDebuggerPort = webDebuggerPort;
        }
    }

    public int getWebDebuggerPort() {
        if (this.webDebuggerPort <= 0) {
            this.webDebuggerPort = 9595;
        }
        return this.webDebuggerPort;
    }

    public boolean getCommit() {
        return this.commit;
    }

    public void setComponentBrowserOrientation(int orientation) {
        this.componentBrowserOrientation = orientation;
    }

    public int getComponentBrowserOrientation() {
        return this.componentBrowserOrientation;
    }

    public void setLanguage(String lang) {
        String old = this.language;
        assert (!Character.isDigit(lang.charAt(lang.length() - 1))) : "Not an abstract language: " + lang;
        this.language = lang;
        this.renderer = null;
        this.fireEvent("language", old, lang);
    }

    public String getLanguage() {
        return this.language;
    }

    public LanguageSpec getLanguageSpec() {
        LanguageSpec spec;
        block4: {
            String language = this.getLanguage();
            spec = null;
            try {
                spec = LanguageSpec.getLanguageSpec((String)language);
            }
            catch (InvalidLanguageException e) {
                try {
                    spec = LanguageSpec.getLanguageSpec((String)"Fuego");
                }
                catch (InvalidLanguageException e1) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"Missing language 'Fuego'");
                }
            }
        }
        return spec;
    }

    public List<String> getLastFindWords() {
        return this.lastFindWords;
    }

    public String getLastFindWordsAsString() {
        String returnString = "";
        Iterator<String> it = this.getLastFindWords().iterator();
        int i = 0;
        while (it.hasNext()) {
            String s = it.next();
            returnString = returnString.equals("") ? returnString + s : returnString + "|" + s;
            if (++i != 10) continue;
            break;
        }
        return returnString;
    }

    public void setLastFindWordsFromString(String lastWords) {
        this.lastFindWords.clear();
        StringTokenizer st = new StringTokenizer(lastWords, "|");
        if (st.hasMoreTokens()) {
            do {
                this.lastFindWords.add(st.nextToken());
            } while (st.hasMoreTokens());
        } else {
            this.lastFindWords.add(lastWords);
        }
    }

    public List<String> getLastReplaceWords() {
        return this.lastReplaceWords;
    }

    public String getLastReplaceWordsAsString() {
        String returnString = "";
        Iterator<String> it = this.getLastReplaceWords().iterator();
        int i = 0;
        while (it.hasNext()) {
            String s = it.next();
            returnString = returnString.equals("") ? returnString + s : returnString + "|" + s;
            if (++i != 10) continue;
            break;
        }
        return returnString;
    }

    public void setLastReplaceWordsFromString(String lastWords) {
        this.lastReplaceWords.clear();
        StringTokenizer st = new StringTokenizer(lastWords, "|");
        if (st.hasMoreTokens()) {
            do {
                this.lastReplaceWords.add(st.nextToken());
            } while (st.hasMoreTokens());
        } else {
            this.lastReplaceWords.add(lastWords);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public int getPreferedSyntax() {
        if (this.intSyntax < 0) {
            this.intSyntax = this.syntax.equals(FUNCTIONAL) ? 2 : (this.syntax.equals(OO) ? 1 : 0);
        }
        return this.intSyntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
        this.intSyntax = -1;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public TypeRenderer getTypeRenderer() {
        if (this.renderer == null) {
            this.renderer = this.getLanguageSpec().getTypeRenderer();
        }
        return this.renderer;
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.put(listener, PRESENT);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(EDITOR_PREFERENCES_FILE);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
            this.writeXML(writer);
            writer.flush();
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeXML(Writer writer) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        xmlWriter.startDocument();
        xmlWriter.startElement("CilEditorPreferences");
        xmlWriter.startElement("preferredSyntax");
        xmlWriter.printAttribute("syntax", this.syntax);
        xmlWriter.endElement();
        xmlWriter.startElement("language");
        xmlWriter.printAttribute("name", this.language);
        xmlWriter.endElement();
        xmlWriter.startElement("General");
        xmlWriter.printAttribute("path", this.path);
        xmlWriter.printAttribute("componentBrowserOrientation", this.getComponentBrowserOrientation());
        xmlWriter.endElement();
        xmlWriter.startElement("codeInsight");
        xmlWriter.printAttribute("autoCompleteDelay", this.autoCompleteDelay);
        xmlWriter.printAttribute("autoCompleteDelayEnabled", this.autoCompleteDelayEnabled);
        xmlWriter.endElement();
        xmlWriter.startElement("search");
        xmlWriter.printAttribute("lastFindWords", this.getLastFindWordsAsString());
        xmlWriter.printAttribute("lastReplaceWords", this.getLastReplaceWordsAsString());
        xmlWriter.endElement();
        xmlWriter.startElement("commit");
        xmlWriter.printAttribute("value", this.getCommit());
        xmlWriter.endElement();
        xmlWriter.startElement("webDebuggerPort");
        xmlWriter.printAttribute("value", this.getWebDebuggerPort());
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    private static synchronized void load() {
        instance = new EditorPreferences();
        File f = EDITOR_PREFERENCES_FILE;
        if (f.exists()) {
            new EditorPreferencesLoader(f, instance);
        }
    }

    private void fireEvent(String property, Object oldValue, Object newValue) {
        if (Any.equals(oldValue, newValue) || this.listeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, property, oldValue, newValue);
        for (PropertyChangeListener o : this.listeners.keySet()) {
            PropertyChangeListener listener = o;
            if (listener == null) continue;
            listener.propertyChange(event);
        }
    }

    private void restoreToDefault() {
        this.syntax = VERBOSE;
    }

    public static class EditorPreferencesLoader
    implements ContentHandler {
        private File file;
        private EditorPreferences preferences;

        public EditorPreferencesLoader(File f, EditorPreferences pref) {
            this.file = f;
            this.preferences = pref;
            this.load();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String local, String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] chars, int start, int end) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
            if (name.equals("preferredSyntax")) {
                this.manageSyntaxInfo(amap);
                return;
            }
            if (name.equals("language")) {
                this.manageLanguage(amap);
                return;
            }
            if (name.equals("General")) {
                this.manageGeneralInfo(amap);
                return;
            }
            if (name.equals("codeInsight")) {
                this.manageCodeInsightInfo(amap);
                return;
            }
            if (name.equals("search")) {
                this.manageSearchInfo(amap);
                return;
            }
            if (name.equals("commit")) {
                this.manageCommitInfo(amap);
            }
            if (name.equals("webDebuggerPort")) {
                this.manageWebDebuggerPortInfo(amap);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        private void manageWebDebuggerPortInfo(Attributes amap) {
            this.preferences.setWebDebuggerPort(Integer.parseInt(amap.getValue("value")));
        }

        private void load() {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                XMLReader parser = sp.getXMLReader();
                parser.setContentHandler(this);
                parser.parse("file:" + this.file.getAbsolutePath());
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }

        private void manageCodeInsightInfo(Attributes amap) {
            this.preferences.setAutoCompleteDelayEnabled(false);
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("autoCompleteDelay")) {
                    this.preferences.setAutoCompleteDelay(Integer.parseInt(value));
                    continue;
                }
                if (attname.equals("autoCompleteDelayEnabled")) {
                    this.preferences.setAutoCompleteDelayEnabled(Boolean.valueOf(value));
                    continue;
                }
                EditorMsg.INVALID_PREFERENCE(attname).logWarning();
            }
        }

        private void manageCommitInfo(Attributes amap) {
            this.preferences.setCommit(Boolean.valueOf(amap.getValue("value")));
        }

        private void manageGeneralInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("syntax")) {
                    this.preferences.setSyntax(value);
                    continue;
                }
                if (attname.equals("path")) {
                    this.preferences.setPath(value);
                    continue;
                }
                if (attname.equals("componentBrowserOrientation")) {
                    this.preferences.setComponentBrowserOrientation(Integer.valueOf(value));
                    continue;
                }
                EditorMsg.INVALID_PREFERENCE(attname).logWarning();
            }
        }

        private void manageLanguage(Attributes amap) {
            this.preferences.setLanguage(amap.getValue("name"));
        }

        private void manageSearchInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("lastFindWords")) {
                    this.preferences.setLastFindWordsFromString(value);
                    continue;
                }
                if (attname.equals("lastReplaceWords")) {
                    this.preferences.setLastReplaceWordsFromString(value);
                    continue;
                }
                EditorMsg.INVALID_PREFERENCE(attname).logWarning();
            }
        }

        private void manageSyntaxInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("syntax")) {
                    this.preferences.setSyntax(value);
                    continue;
                }
                EditorMsg.INVALID_PREFERENCE(attname).logWarning();
            }
        }
    }
}

