/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.text.BadLocationException;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.cil.UsageListener;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.editor.EditorCompiler;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.editor.EditorSharedTimer;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.SourceCode;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorContext
implements UsageListener {
    @Nullable
    private volatile EditorCompiler compiler;
    private int compilerDirectives;
    private EditorDocument currentDoc;
    private final List<CilException> errors;
    private long parsed = -1L;
    private EditorDocument requestNewDoc;
    private long slept;
    private ParsingTask task;
    private int[] usageMarks = new int[150];
    private int usageMarksIndex = 0;
    private final List<CilException> warnings;
    private static final int USAGE_MARKS_INCREMENT = 50;

    public EditorContext() {
        this.errors = new ArrayList<CilException>(20);
        this.warnings = new ArrayList<CilException>(20);
    }

    public void setCompilerDirectives(int directives) {
        this.compilerDirectives = directives;
    }

    public int getCompilerDirectives() {
        return this.compilerDirectives;
    }

    @Nullable
    public TypeDescription getDeclaration(int offset) {
        EditorDocument doc = this.currentDoc;
        if (doc != null) {
            MethodTypeDescription method = doc.getMethod();
            if (method == null) {
                return null;
            }
            return this.getCompiler().getFuegoCompiler().getDeclarationFor((TypeDescription)method, offset);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(EditorDocument doc, boolean validate) {
        EditorContext editorContext = this;
        synchronized (editorContext) {
            if (this.currentDoc != doc) {
                this.requestNewDoc = doc;
                this.currentDoc = null;
            }
        }
        if (validate && this.task == null) {
            Timer timer = EditorSharedTimer.get();
            this.task = new ParsingTask(this);
            timer.schedule((TimerTask)this.task, 0L, 700L);
        }
    }

    @Override
    public void reportError(CilException exception) {
        this.errors.add(exception);
    }

    @Override
    public void reportWarning(CilException exception) {
        this.warnings.add(exception);
    }

    public void run() {
        this.parse();
    }

    @Override
    public void usage(int offset, int length, int type) {
        if (offset < 0) {
            return;
        }
        if (this.usageMarksIndex == this.usageMarks.length) {
            int[] array = new int[this.usageMarks.length + 150];
            System.arraycopy(this.usageMarks, 0, array, 0, this.usageMarks.length);
            this.usageMarks = array;
        }
        this.usageMarks[this.usageMarksIndex++] = offset;
        this.usageMarks[this.usageMarksIndex++] = length;
        this.usageMarks[this.usageMarksIndex++] = type;
    }

    public void dispose() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse() {
        EditorContext editorContext = this;
        synchronized (editorContext) {
            if (this.requestNewDoc != null) {
                this.currentDoc = this.requestNewDoc;
                this.requestNewDoc = null;
                this.parsed = -1L;
                this.slept = this.currentDoc.getTimestamp();
            }
        }
        EditorDocument doc = this.currentDoc;
        if (doc != null) {
            long docTimestamp = doc.getTimestamp();
            if (this.parsed != docTimestamp && this.slept == docTimestamp) {
                this.parsed = docTimestamp;
                this.compile();
            }
            this.slept = doc.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EditorCompiler getCompiler() {
        EditorCompiler result = this.compiler;
        if (result == null) {
            EditorContext editorContext = this;
            synchronized (editorContext) {
                result = this.compiler;
                if (result == null) {
                    this.compiler = result = new EditorCompiler();
                    result.getFuegoCompiler().setMessageListener((MessageListener)this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile() {
        block17: {
            try {
                SourceCode code;
                TypeDescription parent;
                EditorDocument doc = this.currentDoc;
                MethodTypeDescription method = doc.getMethod();
                this.errors.clear();
                this.warnings.clear();
                doc.beforeCompilation();
                EditorCompiler compiler = this.getCompiler();
                TypeDescription typeDescription = parent = method != null ? method.getParent() : null;
                if (method == null || parent == null) break block17;
                Object object = doc;
                synchronized (object) {
                    code = SourceCode.create(doc.getChars(), doc.getLanguage().getId());
                }
                object = compiler;
                synchronized (object) {
                    FuegoCompiler fuegoCompiler = compiler.getFuegoCompiler();
                    if (parent instanceof XObjectTypeDescription) {
                        fuegoCompiler.setDirective(8192);
                    } else {
                        fuegoCompiler.clearDirective(8192);
                    }
                    try {
                        boolean isExpression = Modifier.isExpression(method.getModifiers());
                        if (!isExpression || !code.isEmpty() || doc.isExpressionRequired()) {
                            fuegoCompiler.setDirective(this.compilerDirectives);
                            compiler.compileMethod(method, code, parent);
                        }
                    }
                    finally {
                        fuegoCompiler.clearDirective(this.compilerDirectives);
                        if (UiUtilities.isEventDispatchThread()) {
                            throw new IllegalStateException(Thread.currentThread().toString());
                        }
                        this.flushAllMessages(doc);
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            catch (CompilerException e) {
            }
            catch (Throwable unexpected) {
                unexpected.printStackTrace();
            }
        }
    }

    private void flushAllMessages(final EditorDocument doc) {
        if (!UiUtilities.isEventDispatchThread()) {
            try {
                UiUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EditorContext.this.flushAllMessages(doc);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        this.flushUsageMarks();
        this.flushErrors();
        doc.afterCompilation();
    }

    private void flushErrors() {
        assert (UiUtilities.isEventDispatchThread()) : "This method must run from UI thread";
        EditorDocument doc = this.currentDoc;
        if (doc != null) {
            for (CilException exception : this.errors) {
                doc.addError(exception, this.parsed);
            }
            for (CilException warning : this.warnings) {
                doc.addWarning(warning, this.parsed);
            }
        }
        this.errors.clear();
        this.warnings.clear();
    }

    private void flushUsageMarks() {
        assert (UiUtilities.isEventDispatchThread()) : "This method must run from AWT thread";
        EditorDocument doc = this.currentDoc;
        int length = this.usageMarksIndex;
        if (doc != null && length > 0) {
            int[] marks = this.usageMarks;
            for (int i = 0; i < length; i += 3) {
                doc.usage(marks[i], marks[i + 1], marks[i + 2]);
            }
        }
        this.usageMarksIndex = 0;
    }

    private static class ParsingTask
    extends BaseTimerTask {
        protected ParsingTask(EditorContext context) {
            super(context);
        }

        @Override
        protected void execute(EditorContext context) {
            context.parse();
        }
    }

    public static abstract class BaseTimerTask
    extends TimerTask {
        private final WeakReference<EditorContext> reference;

        protected BaseTimerTask(EditorContext context) {
            this.reference = new WeakReference<EditorContext>(context);
        }

        @Override
        public final void run() {
            EditorContext context = (EditorContext)this.reference.get();
            if (context == null) {
                this.cancel();
            } else {
                this.execute(context);
            }
        }

        protected abstract void execute(EditorContext var1);
    }
}

