/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.xml.Serializer;

public final class XMLSerializerWriter
extends IndentedPrintWriter {
    protected String charset;
    protected final Serializer serializer;
    private CharsetEncoder encoder;

    public XMLSerializerWriter(Writer w, Serializer serializer) {
        super(w, true);
        this.charset = "UTF-8";
        this.serializer = serializer;
    }

    public XMLSerializerWriter(OutputStream os, Serializer serializer) {
        super(XMLSerializerWriter.createOutputStreamWriter(os, "UTF-8"), true);
        this.charset = "UTF-8";
        this.serializer = serializer;
    }

    public XMLSerializerWriter(Writer w, Serializer serializer, String charset) {
        super(w, true);
        this.serializer = serializer;
        this.charset = charset;
    }

    public XMLSerializerWriter(OutputStream os, Serializer serializer, String encoding) {
        super(XMLSerializerWriter.createOutputStreamWriter(os, encoding), true);
        this.charset = encoding;
        this.serializer = serializer;
    }

    public static Writer createOutputStreamWriter(OutputStream os, String encoding) {
        try {
            return new BufferedWriter(new OutputStreamWriter(os, encoding));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void write(String objName, Object dobj) {
        this.serializer.serialize(this, objName, dobj);
    }

    public void write(String objName, DynamicObject dobj) {
        this.serializer.serialize(this, objName, dobj);
    }

    public CharsetEncoder getCharsetEncoder() {
        if (this.encoder == null) {
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
            Charset cs = Charset.forName(this.charset);
            this.encoder = cs.newEncoder();
        }
        return this.encoder;
    }
}

