/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NonNls;

public class PublishUtils {
    public static String buildCILClassFileName(String organization, String processName, int major, int minor, String clazz) {
        return PublishUtils.internalBuild(organization, processName, major, minor, clazz, File.separator);
    }

    public static String buildCILClassName(String organization, String processName, int major, int minor, String clazz) {
        return PublishUtils.internalBuild(organization, processName, major, minor, clazz, ".");
    }

    @NonNls
    public static String buildProcedureClassName(String name) {
        return name + ".Instance";
    }

    private static void appendProtected(StringBuffer buff, String str, boolean checkStart) {
        char chr;
        if (str == null) {
            return;
        }
        if (str.length() == 0) {
            return;
        }
        int j = 0;
        StringBuilder auxBuff = new StringBuilder();
        if (checkStart) {
            chr = str.charAt(j);
            auxBuff.append(Character.isJavaIdentifierStart(chr) ? chr : (char)'_');
            ++j;
        }
        for (int i = j; i < str.length(); ++i) {
            chr = str.charAt(i);
            auxBuff.append(Character.isJavaIdentifierPart(chr) ? chr : (char)'_');
        }
        if (auxBuff.charAt(auxBuff.length() - 1) == '_') {
            auxBuff.append('_');
        }
        if (Identifier.belongsToJava(auxBuff.toString())) {
            auxBuff.append('_');
        }
        buff.append(auxBuff.toString());
    }

    private static String internalBuild(String organization, String processName, int major, int minor, String clazz, String sep) {
        StringBuffer buff = new StringBuffer();
        PublishUtils.appendProtected(buff, organization, true);
        buff.append(sep);
        PublishUtils.appendProtected(buff, processName, true);
        buff.append('_');
        String version = String.valueOf(major) + '.' + minor;
        PublishUtils.appendProtected(buff, version, false);
        if (clazz != null && clazz.length() != 0) {
            buff.append(sep);
            PublishUtils.appendProtected(buff, clazz, true);
        }
        return buff.toString();
    }
}

