/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.lang.Str;

public class Properties
extends java.util.Properties {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final long serialVersionUID = 5315008157482825355L;

    public Properties() {
    }

    public Properties(java.util.Properties prop) {
        super(prop);
    }

    public static void store(Map values, OutputStream out, String[] headers) throws IOException {
        Properties.store(values.keySet().iterator(), values, out, headers);
    }

    public static void store(Iterator keys, Map values, OutputStream out, String[] headers) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (headers != null && headers.length > 0) {
            for (String header : headers) {
                if (header == null) continue;
                Properties.writeln(awriter, "#" + header);
            }
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = (String)values.get(key);
            key = Properties.saveConvert(key, true);
            val = val == null ? "" : Properties.saveConvert(val, false);
            Properties.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    public void store(Writer writer, String comments, boolean escUnicode) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, escUnicode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        int c = reader.read();
        block20: while (true) {
            switch (c) {
                case -1: {
                    return;
                }
                case 64: {
                    StringBuilder fileName = new StringBuilder();
                    c = reader.read();
                    while (c != -1 && c != 10) {
                        fileName.append((char)c);
                        c = reader.read();
                    }
                    if ("".equals(fileName.toString())) continue block20;
                    try {
                        Properties prop = new Properties();
                        FileInputStream stream = new FileInputStream(fileName.toString());
                        try {
                            prop.load(stream);
                        }
                        finally {
                            stream.close();
                        }
                        Enumeration<?> propertyNames = prop.propertyNames();
                        while (true) {
                            if (!propertyNames.hasMoreElements()) continue block20;
                            String name = (String)propertyNames.nextElement();
                            this.put(name, prop.get(name));
                        }
                    }
                    catch (FileNotFoundException exc) {
                        continue block20;
                    }
                }
                case 33: 
                case 35: {
                    c = reader.read();
                    while (true) {
                        if (c < 0 || c == 10 || c == 13) continue block20;
                        c = reader.read();
                    }
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    c = reader.read();
                    continue block20;
                }
            }
            StringBuilder key = new StringBuilder();
            block24: while (true) {
                key.append((char)c);
                c = reader.read();
                switch (c) {
                    case -1: {
                        return;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 58: 
                    case 61: {
                        break block24;
                    }
                    default: {
                        continue block24;
                    }
                }
                break;
            }
            while (c == 32 || c == 9) {
                c = reader.read();
            }
            if (c == 61 || c == 58) {
                c = reader.read();
            }
            while (c == 32 || c == 9) {
                c = reader.read();
            }
            StringBuilder value = new StringBuilder();
            int junk = 0;
            block27: while (true) {
                switch (c) {
                    case -1: {
                        return;
                    }
                    case 10: 
                    case 13: {
                        break block27;
                    }
                    case 9: 
                    case 32: {
                        ++junk;
                        break;
                    }
                    default: {
                        junk = 0;
                    }
                }
                value.append((char)c);
                c = reader.read();
            }
            if (junk > 0) {
                value.setLength(value.length() - junk);
            }
            this.put(key.toString(), this.loadConvert(value.toString()));
        }
    }

    public String toSeparatedString(String separator) {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(entry.getKey());
            ret.append('=');
            ret.append(entry.getValue());
        }
        return ret.toString();
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        return Str.encodeUnicodeChars(theString, escapeSpace);
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = Properties.toHex(c >> 12 & 0xF);
                uu[3] = Properties.toHex(c >> 8 & 0xF);
                uu[4] = Properties.toHex(c >> 4 & 0xF);
                uu[5] = Properties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            Properties.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Properties properties = this;
        synchronized (properties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)this.get(key);
                key = escUnicode ? Properties.saveConvert(key, true) : key;
                val = escUnicode ? Properties.saveConvert(val, false) : val;
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private String loadConvert(String theString) {
        return Str.decodeUnicodeChars(theString);
    }
}

