/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemJavaC {
    @NotNull
    private final Map<File, Class> classesByFile;
    @NotNull
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    @NotNull
    private final MemoryJavaFileManager fileManager;
    @NotNull
    private final MemoryClassLoader memoryClassLoader = new MemoryClassLoader(this.getClass().getClassLoader());

    public InMemJavaC() {
        this.fileManager = new MemoryJavaFileManager(this.compiler, this.memoryClassLoader);
        this.classesByFile = new HashMap<File, Class>();
    }

    public static void main(String[] args) throws ClassNotFoundException {
        File source;
        if (args.length < 1) {
            System.err.println("Usage: InMemJavac file arguments...");
            System.exit(0);
        }
        if (!(source = new File(args[0])).exists()) {
            System.err.println("Can't open: " + args[0]);
            System.exit(0);
        }
        System.arraycopy(args, 1, args, 0, args.length - 1);
        InMemJavaC.invokeMain(InMemJavaC.compileAndLoad(null, source), args);
    }

    public static Class compileAndLoad(File sourceDir, File source) throws ClassNotFoundException {
        return new InMemJavaC().compileToClass(sourceDir, source);
    }

    public long sourceLastModified(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/InMemJavaC.sourceLastModified must not be null");
        }
        return this.memoryClassLoader.equals(clazz.getClassLoader()) ? this.memoryClassLoader.sourceLastModified(clazz.getName()) : 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Class<?> compileToClass(@Nullable File sourcePath, @NotNull File source) throws ClassNotFoundException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/util/InMemJavaC.compileToClass must not be null");
        }
        List<String> options = sourcePath == null ? null : Arrays.asList("-sourcepath", sourcePath.getAbsolutePath());
        boolean result = this.compiler.getTask(null, this.fileManager, null, options, null, this.fileManager.getJavaFileObjects(Collections.singleton(source))).call();
        this.fileManager.close();
        if (!result) {
            throw new ClassNotFoundException("Compilation Error");
        }
        Class<?> clazz = this.memoryClassLoader.getClassFromSource(source);
        if (clazz == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/InMemJavaC.compileToClass must not return null");
        }
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Class<?> loadClass(@Nullable File sourcePath, @NotNull File source) throws ClassNotFoundException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/util/InMemJavaC.loadClass must not be null");
        }
        Class<?> clazz = this.classesByFile.get(source);
        if (clazz == null) {
            clazz = this.compileToClass(sourcePath, source);
            this.classesByFile.put(source, clazz);
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/InMemJavaC.loadClass must not return null");
        }
        return clazz2;
    }

    private static void invokeMain(Class<?> clazz, String[] args) {
        try {
            Method m = clazz.getMethod("main", String[].class);
            Object[] a = new Object[]{args};
            m.invoke(null, a);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MemoryJavaFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private MemoryClassLoader memoryClassLoader;

        public MemoryJavaFileManager(JavaCompiler compiler, MemoryClassLoader memoryClassLoader) {
            super(compiler.getStandardFileManager(null, null, null));
            this.memoryClassLoader = memoryClassLoader;
        }

        public Iterable<? extends JavaFileObject> getJavaFileObjects(Iterable<File> files) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String s, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            assert (kind == JavaFileObject.Kind.CLASS);
            return new MemoryJavaOutput(fileObject, s, this.memoryClassLoader);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MemoryClassLoader
    extends ClassLoader {
        @NotNull
        private final HashMap<String, ClassInfo> classMap = new HashMap();

        MemoryClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            ClassInfo classInfo = this.classMap.get(className);
            if (classInfo == null) {
                throw new ClassNotFoundException(className);
            }
            byte[] bytes = classInfo.getBytes();
            return this.defineClass(className, bytes, 0, bytes.length);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        Class<?> getClassFromSource(@NotNull File source) throws ClassNotFoundException {
            String className;
            if (source == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/InMemJavaC$MemoryClassLoader.getClassFromSource must not be null");
            }
            String path = source.getPath();
            int lastDot = path.lastIndexOf(46);
            if (lastDot != -1) {
                path = path.substring(0, lastDot);
            }
            path = path.replace(File.separatorChar, '.');
            Iterator<String> i$ = this.classMap.keySet().iterator();
            do {
                if (i$.hasNext()) continue;
                throw new ClassNotFoundException(source.getPath());
            } while (!path.endsWith(className = i$.next()));
            Class<?> clazz = this.findClass(className);
            if (clazz == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/util/InMemJavaC$MemoryClassLoader.getClassFromSource must not return null");
            }
            return clazz;
        }

        void addClass(String name, ByteArrayOutputStream outputStream, long lastModified) {
            this.classMap.put(name, new ClassInfo(outputStream, lastModified));
        }

        long sourceLastModified(String className) {
            ClassInfo classInfo = this.classMap.get(className);
            return classInfo == null ? 0L : classInfo.lastModified;
        }
    }

    private static class ClassInfo {
        private ByteArrayOutputStream bytes;
        private long lastModified;

        public ClassInfo(ByteArrayOutputStream outputStream, long lastModified) {
            this.bytes = outputStream;
            this.lastModified = lastModified;
        }

        public byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    static class MemoryJavaOutput
    extends SimpleJavaFileObject {
        private String className;
        private long lastModified;
        private MemoryClassLoader memoryClassLoader;

        public MemoryJavaOutput(FileObject fileObject, String className, MemoryClassLoader memoryClassLoader) {
            super(fileObject.toUri(), JavaFileObject.Kind.CLASS);
            this.className = className;
            this.memoryClassLoader = memoryClassLoader;
            this.lastModified = fileObject.getLastModified();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.memoryClassLoader.addClass(this.className, outputStream, this.lastModified);
            return outputStream;
        }
    }
}

