/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public final class ExceptionFormatter {
    private static final Map<String, ResourceMessageMethod> customMessages = Collections.synchronizedMap(new HashMap());
    private static final Class<CoreMsg> customMessagesClass = CoreMsg.class;
    private static final ResourceMessageMethod NONE = new ResourceMessageMethod();

    public static String digestTechLevel(Throwable throwable) {
        return ExceptionFormatter.fullTechLevel(throwable);
    }

    public static String digestTechLevel(DefaultException defaultException, Locale locale) {
        return ExceptionFormatter.fullTechLevel(defaultException, locale);
    }

    public static String digestTechLevel(DefaultRuntimeException defaultRuntimeException, Locale locale) {
        return ExceptionFormatter.fullTechLevel(defaultRuntimeException, locale);
    }

    public static String endUserLevel(Throwable throwable) {
        return ExceptionFormatter.messages(throwable).toString();
    }

    public static String endUserLevel(DefaultException defaultException, Locale locale) {
        return ExceptionFormatter.messages(defaultException, locale).toString();
    }

    public static String endUserLevel(Throwable throwable, Locale locale) {
        return ExceptionFormatter.messages(throwable, locale).toString();
    }

    public static String endUserLevel(DefaultRuntimeException defaultException, Locale locale) {
        return ExceptionFormatter.messages(defaultException, locale).toString();
    }

    public static String fullTechLevel(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuffer message = ExceptionFormatter.messages(throwable);
        message.append("\n");
        message.append(ExceptionFormatter.stackTrace(throwable));
        return message.toString();
    }

    public static String fullTechLevel(DefaultException defaultException, Locale locale) {
        return ExceptionFormatter.formatLocalizedFullTechLevel(defaultException, locale);
    }

    public static String fullTechLevel(DefaultRuntimeException defaultRuntimeException, Locale locale) {
        return ExceptionFormatter.formatLocalizedFullTechLevel(defaultRuntimeException, locale);
    }

    private static String getMessage(Throwable currentThrowable, Locale locale) {
        String result = null;
        if (currentThrowable instanceof DefaultException) {
            DefaultException defaultException = (DefaultException)currentThrowable;
            if (!CoreMsg.NO_MESSAGE_CODE.equals(defaultException.getKey())) {
                result = ExceptionFormatter.getMessageForException(defaultException, locale);
            }
        } else {
            result = currentThrowable instanceof DefaultRuntimeException ? ExceptionFormatter.getMessageForException((DefaultRuntimeException)currentThrowable, locale) : ExceptionFormatter.getMessageForException(currentThrowable, locale);
        }
        return result;
    }

    private static ResourceMessageMethod findMessageForException(String className) {
        className = className.replace('.', '_');
        ResourceMessageMethod result = null;
        try {
            Method method = ExceptionFormatter.method(className, null);
            if (method != null) {
                result = new ResourceMessageMethod(method);
            } else {
                method = ExceptionFormatter.method(className, new Class[]{String.class});
                if (method != null) {
                    result = new ResourceMessage1ArgMethod(method);
                } else {
                    method = ExceptionFormatter.method(className, new Class[]{String.class, String.class});
                    if (method != null) {
                        result = new ResourceMessage2ArgsMethod(method);
                    }
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private static String formatLocalizedFullTechLevel(Throwable throwable, Locale locale) {
        StringBuffer message = ExceptionFormatter.messages(throwable, locale);
        message.append("\n");
        message.append(ExceptionFormatter.stackTrace(throwable));
        return message.toString();
    }

    private static String getMessageForException(Throwable throwable, Locale locale) {
        String message = throwable.getLocalizedMessage() != null ? throwable.getLocalizedMessage() : throwable.toString();
        String className = throwable.getClass().getName();
        ResourceMessageMethod resourceMessageMethod = customMessages.get(className);
        if (resourceMessageMethod == null && !className.startsWith("fuego.")) {
            resourceMessageMethod = ExceptionFormatter.findMessageForException(className);
            if (resourceMessageMethod != null) {
                customMessages.put(className, resourceMessageMethod);
            } else {
                customMessages.put(className, NONE);
            }
        }
        if (resourceMessageMethod != null && resourceMessageMethod != NONE) {
            message = resourceMessageMethod.invoke(throwable, locale);
        }
        return message;
    }

    private static String getMessageForException(DefaultException defaultException, Locale locale) {
        return defaultException.getMessage(locale);
    }

    private static String getMessageForException(DefaultRuntimeException defaultRuntimeException, Locale locale) {
        return defaultRuntimeException.getMessage(locale);
    }

    private static Throwable ignoreRuntimeExceptionShell(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable currentThrowable = throwable instanceof RuntimeExceptionShell && ((RuntimeExceptionShell)throwable).getOwnMessage() == null ? throwable.getCause() : throwable;
        return currentThrowable;
    }

    private static StringBuffer messages(Throwable throwable) {
        return ExceptionFormatter.messages(throwable, Locale.getDefault());
    }

    private static StringBuffer messages(Throwable throwable, Locale locale) {
        StringBuffer message = new StringBuffer();
        Throwable currentThrowable = ExceptionFormatter.ignoreRuntimeExceptionShell(throwable);
        while (currentThrowable != null) {
            String throwableMessage = ExceptionFormatter.getMessage(currentThrowable, locale);
            if (throwableMessage != null) {
                if (message.length() > 0) {
                    message.append("\n").append(CoreMsg.CAUSED_BY).append(": ");
                }
                message.append(throwableMessage);
            }
            if (currentThrowable instanceof SQLException) {
                currentThrowable = ((SQLException)currentThrowable).getNextException();
                continue;
            }
            currentThrowable = ExceptionFormatter.ignoreRuntimeExceptionShell(currentThrowable.getCause());
        }
        return message;
    }

    private static Method method(String className, Class[] args) {
        try {
            return customMessagesClass.getMethod(className.toUpperCase(), args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }

    private static class ResourceMessageMethod {
        Method resMethod;

        public ResourceMessageMethod(Method method) {
            this.setMethod(method);
        }

        private ResourceMessageMethod() {
        }

        public final Method getMethod() {
            return this.resMethod;
        }

        public String invoke(Throwable throwable, Locale locale) {
            String message = null;
            try {
                Msg msg = (Msg)this.getMethod().invoke(null, (Object[])null);
                message = locale != null ? msg.getString(locale) : msg.getString();
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return message;
        }

        public final void setMethod(Method method) {
            this.resMethod = method;
        }
    }

    private static final class ResourceMessage2ArgsMethod
    extends ResourceMessageMethod {
        public ResourceMessage2ArgsMethod(Method method) {
            super(method);
        }

        @Override
        public String invoke(Throwable throwable, Locale locale) {
            String message = null;
            try {
                StackTraceElement[] stack = throwable.getStackTrace();
                String sourceClassName = stack[0].getClassName();
                String sourceMethodName = stack[0].getMethodName();
                if (sourceClassName.startsWith("xobject")) {
                    sourceClassName = sourceClassName.substring("xobject".length());
                }
                Msg msg = (Msg)this.getMethod().invoke(null, sourceClassName, sourceMethodName);
                message = locale != null ? msg.getString(locale) : msg.getString();
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return message;
        }
    }

    private static final class ResourceMessage1ArgMethod
    extends ResourceMessageMethod {
        public ResourceMessage1ArgMethod(Method method) {
            super(method);
        }

        @Override
        public String invoke(Throwable throwable, Locale locale) {
            String message = null;
            try {
                Msg msg = (Msg)this.getMethod().invoke(null, throwable.getMessage());
                message = locale != null ? msg.getString(locale) : msg.getString();
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return message;
        }
    }
}

