/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Interval;

public final class DefaultValue {
    private static Map<Class<?>, Object> defaultValueTable = new HashMap();

    public static <T> T forClass(Class<T> clazz) {
        return DefaultValue.forClass(clazz, false);
    }

    public static <T> T forClass(Class<T> clazz, boolean instantiate) {
        T value = null;
        if (clazz != null && (value = (T)DefaultValue.getDefaultValue(clazz)) == null) {
            value = DefaultValue.newInstance(clazz, instantiate);
        }
        return value;
    }

    private static <T> T getDefaultValue(Class<T> clazz) {
        Object t = null;
        return Cast.forceTo(t, defaultValueTable.get(clazz));
    }

    private static <T> T newInstance(Class<T> clazz, boolean instantiate) {
        T value = null;
        if (clazz.isArray()) {
            value = clazz.cast(Array.newInstance(clazz.getComponentType(), 0));
        } else if (clazz.isInterface()) {
            Cloneable v = null;
            if (List.class.isAssignableFrom(clazz)) {
                v = new ArrayList();
            } else if (SortedSet.class.isAssignableFrom(clazz)) {
                v = new TreeSet();
            } else if (Set.class.isAssignableFrom(clazz)) {
                v = new LinkedHashSet();
            } else if (SortedMap.class.isAssignableFrom(clazz)) {
                v = new TreeMap();
            } else if (Map.class.isAssignableFrom(clazz)) {
                v = new HashMap();
            }
            value = clazz.cast(v);
        } else if (instantiate) {
            try {
                value = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    static {
        defaultValueTable.put(Integer.class, 0);
        defaultValueTable.put(Long.class, 0L);
        defaultValueTable.put(Short.class, (short)0);
        defaultValueTable.put(Byte.class, (byte)0);
        defaultValueTable.put(Double.class, 0.0);
        defaultValueTable.put(Float.class, Float.valueOf(0.0f));
        defaultValueTable.put(Character.class, Character.valueOf('\u0000'));
        defaultValueTable.put(Integer.TYPE, 0);
        defaultValueTable.put(Long.TYPE, 0L);
        defaultValueTable.put(Short.TYPE, (short)0);
        defaultValueTable.put(Byte.TYPE, (byte)0);
        defaultValueTable.put(Double.TYPE, 0.0);
        defaultValueTable.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValueTable.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValueTable.put(Boolean.TYPE, Boolean.FALSE);
        defaultValueTable.put(String.class, "");
        defaultValueTable.put(BigDecimal.class, BigDecimal.ZERO);
        defaultValueTable.put(BigInteger.class, BigInteger.ZERO);
        defaultValueTable.put(Interval.class, Interval.valueOf(0L));
        defaultValueTable.put(Iterator.class, Collections.EMPTY_LIST.iterator());
    }
}

