/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpm.collections.maps.WeakValueHashMap;
import oracle.bpm.log.Log;
import oracle.bpm.util.NumberFormat;
import org.jetbrains.annotations.NonNls;

public class DateFormatUtils {
    @NonNls
    private static final String DATE_TIME_PATTERNS = "DateTimePatterns";
    @NonNls
    private static final String ENGLISH_DEFAULT_PATTERN = "M/d/yyyy";
    private static final String patternChars = new DateFormatSymbols(Locale.ENGLISH).getLocalPatternChars();
    private static final WeakValueHashMap<String, String> patternCache = new WeakValueHashMap();
    public static final int DEFAULT_SHORT = 3;
    public static final int DEFAULT_MEDIUM = 2;
    public static final int DEFAULT_LONG = 1;
    public static final int DEFAULT_FULL = 0;
    public static final int DEFAULT = 2;
    public static final int MONTH_DATE_SHORT = 20;
    public static final int MONTH_DATE_MEDIUM = 21;
    public static final int MONTH_DATE_LONG = 22;
    public static final int MONTH_DATE_FULL = 23;
    public static final int MONTH_DATE_DEFAULT = 24;

    public static SimpleDateFormat getDateInstance(int style) {
        return DateFormatUtils.getDateInstance(style, Locale.getDefault());
    }

    public static SimpleDateFormat getDateInstance(int style, Locale locale) {
        String pattern = DateFormatUtils.getDatePattern(style, locale);
        return new SimpleDateFormat(pattern, locale);
    }

    public static String getDatePattern(int style, Locale locale) {
        String patternKey = String.valueOf(style) + locale;
        String pattern = patternCache.get(patternKey);
        if (pattern == null) {
            String dateFormatPattern = DateFormatUtils.getJavaDateFormatPattern(style, locale);
            pattern = DateFormatUtils.convertDatePatternToStyle(style, dateFormatPattern);
            patternCache.put(patternKey, pattern);
        }
        return pattern;
    }

    public static String removeCharFromPattern(char charToRemove, String pattern) {
        if (pattern != null) {
            int charIndex;
            while ((charIndex = pattern.indexOf(charToRemove)) != -1) {
                char currentChar;
                int i;
                StringBuilder newPatternBuffer = new StringBuilder();
                if (pattern.length() <= 0) continue;
                boolean isEscape = false;
                boolean isAlreadyFixed = false;
                for (i = charIndex - 1; i >= 0; --i) {
                    currentChar = pattern.charAt(i);
                    if (DateFormatUtils.isPatternChar(currentChar) && !isEscape) {
                        newPatternBuffer.append(pattern.substring(0, i + 1));
                        break;
                    }
                    isAlreadyFixed = true;
                    if (currentChar != '\'') continue;
                    if (i - 1 >= 0 && pattern.charAt(i - 1) == '\'') {
                        --i;
                        continue;
                    }
                    isEscape = !isEscape;
                }
                isEscape = false;
                for (i = charIndex + 1; i < pattern.length(); ++i) {
                    currentChar = pattern.charAt(i);
                    if (currentChar != charToRemove && (isAlreadyFixed || DateFormatUtils.isPatternChar(currentChar)) && !isEscape) {
                        newPatternBuffer.append(pattern.substring(i));
                        break;
                    }
                    if (currentChar != '\'') continue;
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    isEscape = !isEscape;
                }
                pattern = newPatternBuffer.toString();
            }
        }
        return pattern;
    }

    public static void main(String[] args) {
        System.out.println("MONTH DATE FORMAT =================================================");
        Locale[] locales = Locale.getAvailableLocales();
        Date now = Calendar.getInstance().getTime();
        for (Locale locale : locales) {
            SimpleDateFormat shortDateFormat = DateFormatUtils.getDateInstance(20, locale);
            SimpleDateFormat defaultShortDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
            SimpleDateFormat mediumDateFormat = DateFormatUtils.getDateInstance(21, locale);
            SimpleDateFormat defaultMediumDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
            SimpleDateFormat longDateFormat = DateFormatUtils.getDateInstance(22, locale);
            SimpleDateFormat defaultLongDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
            SimpleDateFormat fullDateFormat = DateFormatUtils.getDateInstance(23, locale);
            SimpleDateFormat defaultFullDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(0, locale);
            System.out.println("-----------------------");
            System.out.println("locale = " + locale);
            System.out.println("SHORT dateFormat \t\t= " + defaultShortDateFormat.toPattern() + "\t=> " + shortDateFormat.toPattern() + "\t => " + shortDateFormat.format(now));
            System.out.println("MEDIUM dateFormat \t\t= " + defaultMediumDateFormat.toPattern() + "\t=> " + mediumDateFormat.toPattern() + "\t => " + mediumDateFormat.format(now));
            System.out.println("LONG dateFormat \t\t= " + defaultLongDateFormat.toPattern() + "\t=> " + longDateFormat.toPattern() + "\t => " + longDateFormat.format(now));
            System.out.println("FULL dateFormat \t\t= " + defaultFullDateFormat.toPattern() + "\t=> " + fullDateFormat.toPattern() + "\t => " + fullDateFormat.format(now));
        }
    }

    private static String convertDatePatternToStyle(int style, String pattern) {
        String newPattern;
        switch (style) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                newPattern = DateFormatUtils.removeCharFromPattern('y', pattern);
                newPattern = DateFormatUtils.removeCharFromPattern('E', newPattern);
                break;
            }
            default: {
                newPattern = pattern;
            }
        }
        return newPattern;
    }

    private static boolean isPatternChar(char theChar) {
        return patternChars.indexOf(theChar) != -1;
    }

    private static String getJavaDateFormatPattern(int style, Locale locale) {
        String pattern;
        int dateStyle;
        switch (style) {
            case 20: {
                dateStyle = 3;
                break;
            }
            case 21: {
                dateStyle = 2;
                break;
            }
            case 22: {
                dateStyle = 1;
                break;
            }
            case 23: {
                dateStyle = 0;
                break;
            }
            case 24: {
                dateStyle = 2;
                break;
            }
            default: {
                dateStyle = style;
            }
        }
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(dateStyle, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            pattern = ((SimpleDateFormat)dateFormat).toPattern();
        } else {
            try {
                ResourceBundle r = NumberFormat.getNumberFormatData(locale);
                String[] dateTimePatterns = r.getStringArray(DATE_TIME_PATTERNS);
                pattern = dateTimePatterns[dateStyle + 4];
            }
            catch (Throwable t) {
                Log.logWarning(t);
                pattern = ENGLISH_DEFAULT_PATTERN;
            }
        }
        return pattern;
    }
}

