/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.bpm.lang.Cast;
import org.jetbrains.annotations.NotNull;

public class BinaryPattern<T> {
    private boolean built;
    private final State<T> start = new State();

    public final void add(byte[] pattern, T action) {
        if (this.built) {
            throw new IllegalStateException("pattern already built");
        }
        this.start.add(0, pattern, action);
    }

    public void build() {
        if (this.built) {
            throw new IllegalStateException("pattern already built");
        }
        this.built = true;
        ArrayList levels = new ArrayList();
        this.start.collectLevels(levels, 0);
        ((State)this.start).failure = (State)this.start;
        for (State child : ((State)this.start).children) {
            child.failure = (State)this.start;
        }
        for (int i = 1; i < levels.size(); ++i) {
            Collection levelStates = (Collection)levels.get(i);
            for (State r : levelStates) {
                if (r.keys.length == 0) {
                    State.access$202(r, ((State)this.start).keys);
                    State.access$102(r, ((State)this.start).children);
                    r.failure = (State)this.start;
                    continue;
                }
                for (int j = 0; j < r.keys.length; ++j) {
                    byte a = r.keys[j];
                    State s = r.children[j];
                    State state = r.failure;
                    State c = state.find(a);
                    while (c == null) {
                        state = state.failure;
                        c = state.find(a);
                    }
                    s.failure = c;
                    if (c.output == null) continue;
                    if (s.output != null) {
                        s.output.addAll(c.output);
                        continue;
                    }
                    s.output = c.output;
                }
            }
        }
        HashSet visited = new HashSet();
        this.start.fixOutput(visited);
    }

    public Matcher<T> createMatcher() {
        if (!this.built) {
            throw new IllegalStateException("pattern not built");
        }
        return new Matcher<T>(this.start);
    }

    private static final class State<T> {
        private State<T>[] children;
        private State<T> failure;
        private byte[] keys = new byte[0];
        @NotNull
        private List<T> output;

        State() {
            this.children = (State[])Cast.force(new State[0]);
            this.output = new ArrayList<T>();
        }

        State<T> find(byte a) {
            int where = Arrays.binarySearch(this.keys, a);
            State<T> result = where < 0 ? this.failure : this.children[where];
            return result;
        }

        void add(int index, byte[] pattern, T action) {
            if (index == pattern.length) {
                this.output.add(action);
            } else {
                byte c = pattern[index];
                int where = Arrays.binarySearch(this.keys, c);
                if (where < 0) {
                    where = -where - 1;
                    byte[] nkeys = new byte[this.keys.length + 1];
                    State[] nchildren = (State[])Cast.force(new State[this.children.length + 1]);
                    System.arraycopy(this.keys, 0, nkeys, 0, where);
                    System.arraycopy(this.keys, where, nkeys, where + 1, this.keys.length - where);
                    System.arraycopy(this.children, 0, nchildren, 0, where);
                    System.arraycopy(this.children, where, nchildren, where + 1, this.children.length - where);
                    this.keys = nkeys;
                    this.children = nchildren;
                    this.keys[where] = pattern[index];
                    this.children[where] = new State<T>();
                }
                this.children[where].add(index + 1, pattern, action);
            }
        }

        void collectLevels(List<Collection<State<T>>> levels, int level) {
            if (levels.size() == level) {
                levels.add(new LinkedList());
            }
            Collection<State<T>> c = levels.get(level);
            c.add(this);
            for (State<T> child : this.children) {
                child.collectLevels(levels, level + 1);
            }
        }

        void fixOutput(Set<State<T>> visited) {
            if (!visited.contains(this)) {
                visited.add(this);
                if (this.output.isEmpty()) {
                    this.output = Collections.emptyList();
                } else if (this.output instanceof ArrayList) {
                    ArrayList o = (ArrayList)this.output;
                    o.trimToSize();
                    this.output = Collections.unmodifiableList(this.output);
                }
                for (State<T> child : this.children) {
                    child.fixOutput(visited);
                }
            }
        }

        static /* synthetic */ byte[] access$202(State x0, byte[] x1) {
            x0.keys = x1;
            return x1;
        }

        static /* synthetic */ State[] access$102(State x0, State[] x1) {
            x0.children = x1;
            return x1;
        }
    }

    public static class Matcher<T> {
        private State<T> current;

        Matcher(State<T> current) {
            this.current = current;
        }

        public List<T> match(byte b) {
            this.current = this.current.find(b);
            return ((State)this.current).output;
        }
    }
}

