/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public final class ArrayIterator<T>
implements Iterator<T>,
Iterable<T> {
    @Nullable
    private Object array;
    private int index;

    private ArrayIterator(@Nullable Object array) {
        assert (array == null || array.getClass().isArray()) : "Argument must be an array";
        this.array = array;
    }

    public static <T> ArrayIterator<T> create(@Nullable Object array) {
        return new ArrayIterator<T>(array);
    }

    @Override
    public boolean hasNext() {
        Object arr = this.array;
        return arr != null && this.index < Array.getLength(arr);
    }

    @Override
    public T next() {
        Object result;
        int i = this.index;
        try {
            result = Array.get(this.array, i);
        }
        catch (NullPointerException e) {
            throw ArrayIterator.buildException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ArrayIterator.buildException(e);
        }
        this.index = i + 1;
        return (T)result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    private static NoSuchElementException buildException(Exception e) {
        NoSuchElementException result = new NoSuchElementException(e.getMessage());
        result.initCause(e);
        return result;
    }
}

